/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.sound;

import java.util.concurrent.ConcurrentHashMap;

public class Simple3DAudio {
    private final ConcurrentHashMap<Integer, PlayerAudioSource> playerSources = new ConcurrentHashMap();
    public double listenerX = 0.0;
    public double listenerY = 0.0;
    public double listenerZ = 0.0;
    public float listenerYaw = 0.0f;
    public float listenerPitch = 0.0f;

    public boolean initialize() {
        System.out.println("Simple 3D audio system initialized");
        return true;
    }

    public PlayerAudioSource getOrCreatePlayerSource(Integer n2) {
        return this.playerSources.computeIfAbsent(n2, n -> {
            System.out.println("Created audio source for player " + n);
            return new PlayerAudioSource();
        });
    }

    public void updateListener(double d, double d2, double d3, float f, float f2) {
        this.listenerX = d;
        this.listenerY = d2;
        this.listenerZ = d3;
        this.listenerYaw = f;
        this.listenerPitch = f2;
    }

    public void playPlayerAudio(Integer n, byte[] byArray, double d, double d2, double d3, float f) {
        PlayerAudioSource playerAudioSource = this.getOrCreatePlayerSource(n);
        if (playerAudioSource != null) {
            byte[] byArray2 = this.calculateStereoPositioning(byArray, d, d2, d3, f);
            playerAudioSource.playAudio(byArray2);
        }
    }

    private byte[] calculateStereoPositioning(byte[] byArray, double d, double d2, double d3, float f) {
        double d4;
        double d5 = d - this.listenerX;
        double d6 = d3 - this.listenerZ;
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        for (d4 = Math.atan2(d6, d5) - Math.toRadians(this.listenerYaw); d4 > Math.PI; d4 -= Math.PI * 2) {
        }
        while (d4 < -Math.PI) {
            d4 += Math.PI * 2;
        }
        float f2 = (float)Math.sin(d4);
        float f3 = (float)Math.max(0.1, Math.min(1.0, 10.0 / Math.max(1.0, d7)));
        return this.applyStereoPanning(byArray, f2 *= f3, f);
    }

    private byte[] applyStereoPanning(byte[] byArray, float f, float f2) {
        if (Math.abs(f) < 0.01f) {
            return this.duplicateMonoToStereo(byArray, f2);
        }
        byte[] byArray2 = new byte[byArray.length * 2];
        for (int i = 0; i < byArray.length; i += 2) {
            if (i + 1 >= byArray.length) continue;
            short s2 = (short)(byArray[i + 1] << 8 | byArray[i] & 0xFF);
            s2 = (short)((float)s2 * f2);
            float f3 = (float)Math.sqrt((1.0f - f) / 2.0f);
            float f4 = (float)Math.sqrt((1.0f + f) / 2.0f);
            short s3 = (short)((float)s2 * f3);
            short s4 = (short)((float)s2 * f4);
            int n = i / 2 * 4;
            byArray2[n] = (byte)(s3 & 0xFF);
            byArray2[n + 1] = (byte)(s3 >> 8 & 0xFF);
            byArray2[n + 2] = (byte)(s4 & 0xFF);
            byArray2[n + 3] = (byte)(s4 >> 8 & 0xFF);
        }
        return byArray2;
    }

    private byte[] duplicateMonoToStereo(byte[] byArray, float f) {
        byte[] byArray2 = new byte[byArray.length * 2];
        for (int i = 0; i < byArray.length; i += 2) {
            if (i + 1 >= byArray.length) continue;
            short s2 = (short)(byArray[i + 1] << 8 | byArray[i] & 0xFF);
            s2 = (short)((float)s2 * f);
            int n = i / 2 * 4;
            byArray2[n] = (byte)(s2 & 0xFF);
            byArray2[n + 1] = (byte)(s2 >> 8 & 0xFF);
            byArray2[n + 2] = (byte)(s2 & 0xFF);
            byArray2[n + 3] = (byte)(s2 >> 8 & 0xFF);
        }
        return byArray2;
    }

    public void removePlayerSource(Integer n) {
        PlayerAudioSource playerAudioSource = this.playerSources.remove(n);
        if (playerAudioSource != null) {
            playerAudioSource.cleanup();
        }
    }

    public boolean isInitialized() {
        return true;
    }

    public void cleanup() {
        for (PlayerAudioSource playerAudioSource : this.playerSources.values()) {
            if (playerAudioSource == null) continue;
            playerAudioSource.cleanup();
        }
        this.playerSources.clear();
    }

    public static class PlayerAudioSource {
        public void playAudio(byte[] byArray) {
        }

        public void cleanup() {
        }
    }
}

