/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GroupCreatePacket
extends UdpPacket {
    private String groupName;
    private String password;

    public GroupCreatePacket() {
        super(UdpPacket.PacketType.GROUP_CREATE);
    }

    public GroupCreatePacket(String string, String string2) {
        super(UdpPacket.PacketType.GROUP_CREATE);
        this.groupName = string;
        this.password = string2;
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.groupName != null ? this.groupName : "");
        dataOutputStream.writeBoolean(this.password != null);
        if (this.password != null) {
            dataOutputStream.writeUTF(this.password);
        }
    }

    public static GroupCreatePacket read(DataInputStream dataInputStream) throws IOException {
        GroupCreatePacket groupCreatePacket = new GroupCreatePacket();
        groupCreatePacket.groupName = dataInputStream.readUTF();
        boolean bl = dataInputStream.readBoolean();
        groupCreatePacket.password = bl ? dataInputStream.readUTF() : null;
        return groupCreatePacket;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isPublic() {
        return this.password == null || this.password.isEmpty();
    }
}

