/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GroupDataPacket
extends UdpPacket {
    private String groupName;
    private Integer fromPlayerNetworkId;
    private byte[] audioData;
    private long sequenceNumber;
    private List<Integer> targetPlayerIds;

    public GroupDataPacket() {
        super(UdpPacket.PacketType.GROUP_DATA);
        this.targetPlayerIds = new ArrayList<Integer>();
    }

    public GroupDataPacket(String string, Integer n, byte[] byArray, long l, List<Integer> arrayList) {
        super(UdpPacket.PacketType.GROUP_DATA);
        this.groupName = string;
        this.fromPlayerNetworkId = n;
        this.audioData = byArray;
        this.sequenceNumber = l;
        this.targetPlayerIds = arrayList != null ? arrayList : new ArrayList();
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.groupName != null ? this.groupName : "");
        dataOutputStream.writeInt(this.fromPlayerNetworkId);
        dataOutputStream.writeLong(this.sequenceNumber);
        dataOutputStream.writeInt(this.targetPlayerIds.size());
        for (Integer n : this.targetPlayerIds) {
            dataOutputStream.writeInt(n);
        }
        dataOutputStream.writeInt(this.audioData.length);
        dataOutputStream.write(this.audioData);
    }

    public static GroupDataPacket read(DataInputStream dataInputStream) throws IOException {
        int n;
        GroupDataPacket groupDataPacket = new GroupDataPacket();
        groupDataPacket.groupName = dataInputStream.readUTF();
        groupDataPacket.fromPlayerNetworkId = dataInputStream.readInt();
        groupDataPacket.sequenceNumber = dataInputStream.readLong();
        int n2 = dataInputStream.readInt();
        for (n = 0; n < n2; ++n) {
            groupDataPacket.targetPlayerIds.add(dataInputStream.readInt());
        }
        n = dataInputStream.readInt();
        if (n < 0 || n > 1024) {
            throw new IOException("Invalid audio data length: " + n);
        }
        groupDataPacket.audioData = new byte[n];
        try {
            dataInputStream.readFully(groupDataPacket.audioData);
        }
        catch (EOFException eOFException) {
            throw new IOException("Insufficient data in packet: expected " + n + " bytes", eOFException);
        }
        return groupDataPacket;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Integer getFromPlayerNetworkId() {
        return this.fromPlayerNetworkId;
    }

    public byte[] getAudioData() {
        return this.audioData;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public List<Integer> getTargetPlayerIds() {
        return this.targetPlayerIds;
    }
}

