/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GroupJoinPacket
extends UdpPacket {
    private String groupName;
    private String password;

    public GroupJoinPacket() {
        super(UdpPacket.PacketType.GROUP_JOIN);
    }

    public GroupJoinPacket(String string, String string2) {
        super(UdpPacket.PacketType.GROUP_JOIN);
        this.groupName = string;
        this.password = string2;
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.groupName != null ? this.groupName : "");
        dataOutputStream.writeBoolean(this.password != null);
        if (this.password != null) {
            dataOutputStream.writeUTF(this.password);
        }
    }

    public static GroupJoinPacket read(DataInputStream dataInputStream) throws IOException {
        GroupJoinPacket groupJoinPacket = new GroupJoinPacket();
        groupJoinPacket.groupName = dataInputStream.readUTF();
        boolean bl = dataInputStream.readBoolean();
        groupJoinPacket.password = bl ? dataInputStream.readUTF() : null;
        return groupJoinPacket;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isPublic() {
        return this.password == null || this.password.isEmpty();
    }
}

