/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GroupListPacket
extends UdpPacket {
    private List<GroupInfo> groups;

    public GroupListPacket() {
        super(UdpPacket.PacketType.GROUP_LIST);
        this.groups = new ArrayList<GroupInfo>();
    }

    public GroupListPacket(List<GroupInfo> arrayList) {
        super(UdpPacket.PacketType.GROUP_LIST);
        this.groups = arrayList != null ? arrayList : new ArrayList();
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.groups.size());
        for (GroupInfo groupInfo : this.groups) {
            dataOutputStream.writeUTF(groupInfo.getName());
            dataOutputStream.writeBoolean(groupInfo.hasPassword());
            dataOutputStream.writeInt(groupInfo.getMemberCount());
        }
    }

    public static GroupListPacket read(DataInputStream dataInputStream) throws IOException {
        GroupListPacket groupListPacket = new GroupListPacket();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            boolean bl = dataInputStream.readBoolean();
            int n2 = dataInputStream.readInt();
            groupListPacket.groups.add(new GroupInfo(string, bl, n2));
        }
        return groupListPacket;
    }

    public List<GroupInfo> getGroups() {
        return this.groups;
    }

    public static class GroupInfo {
        private final String name;
        private final boolean hasPassword;
        private final int memberCount;

        public GroupInfo(String string, boolean bl, int n) {
            this.name = string;
            this.hasPassword = bl;
            this.memberCount = n;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasPassword() {
            return this.hasPassword;
        }

        public int getMemberCount() {
            return this.memberCount;
        }
    }
}

