/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GroupMemberUpdatePacket
extends UdpPacket {
    private UpdateType updateType;
    private String groupName;
    private Integer playerNetworkId;
    private String playerName;
    private List<String> groupMembers;

    public GroupMemberUpdatePacket() {
        super(UdpPacket.PacketType.GROUP_MEMBER_UPDATE);
        this.groupMembers = new ArrayList<String>();
    }

    public GroupMemberUpdatePacket(UpdateType updateType, String string, Integer n, String string2, List<String> arrayList) {
        super(UdpPacket.PacketType.GROUP_MEMBER_UPDATE);
        this.updateType = updateType;
        this.groupName = string;
        this.playerNetworkId = n;
        this.playerName = string2;
        this.groupMembers = arrayList != null ? arrayList : new ArrayList();
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.updateType.getId());
        dataOutputStream.writeUTF(this.groupName != null ? this.groupName : "");
        dataOutputStream.writeInt(this.playerNetworkId != null ? this.playerNetworkId : -1);
        dataOutputStream.writeUTF(this.playerName != null ? this.playerName : "");
        dataOutputStream.writeInt(this.groupMembers.size());
        for (String string : this.groupMembers) {
            dataOutputStream.writeUTF(string);
        }
    }

    public static GroupMemberUpdatePacket read(DataInputStream dataInputStream) throws IOException {
        GroupMemberUpdatePacket groupMemberUpdatePacket = new GroupMemberUpdatePacket();
        groupMemberUpdatePacket.updateType = UpdateType.fromId(dataInputStream.readByte());
        groupMemberUpdatePacket.groupName = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        groupMemberUpdatePacket.playerNetworkId = n == -1 ? null : Integer.valueOf(n);
        groupMemberUpdatePacket.playerName = dataInputStream.readUTF();
        int n2 = dataInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            groupMemberUpdatePacket.groupMembers.add(dataInputStream.readUTF());
        }
        return groupMemberUpdatePacket;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Integer getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public List<String> getGroupMembers() {
        return this.groupMembers;
    }

    public static enum UpdateType {
        MEMBER_JOINED(0),
        MEMBER_LEFT(1),
        GROUP_CREATED(2),
        GROUP_DELETED(3);

        private final int id;

        private UpdateType(int n2) {
            this.id = n2;
        }

        public int getId() {
            return this.id;
        }

        public static UpdateType fromId(int n) {
            for (UpdateType updateType : UpdateType.values()) {
                if (updateType.id != n) continue;
                return updateType;
            }
            throw new IllegalArgumentException("Unknown update type: " + n);
        }
    }
}

