/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PresenceBulkPacket
extends UdpPacket {
    private Map<Integer, PlayerState> playerStates = new HashMap<Integer, PlayerState>();

    public PresenceBulkPacket() {
        super(UdpPacket.PacketType.PRESENCE_BULK);
    }

    public PresenceBulkPacket(Map<Integer, PlayerState> map) {
        super(UdpPacket.PacketType.PRESENCE_BULK);
        this.playerStates = map;
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.playerStates.size());
        for (Map.Entry<Integer, PlayerState> entry : this.playerStates.entrySet()) {
            dataOutputStream.writeInt(entry.getKey());
            dataOutputStream.writeBoolean(entry.getValue().voiceSupported);
            dataOutputStream.writeBoolean(entry.getValue().deafened);
        }
    }

    public static PresenceBulkPacket read(DataInputStream dataInputStream) throws IOException {
        PresenceBulkPacket presenceBulkPacket = new PresenceBulkPacket();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            boolean bl = dataInputStream.readBoolean();
            boolean bl2 = dataInputStream.readBoolean();
            presenceBulkPacket.playerStates.put(n2, new PlayerState(bl, bl2));
        }
        return presenceBulkPacket;
    }

    public Map<Integer, PlayerState> getPlayerStates() {
        return this.playerStates;
    }

    public static class PlayerState {
        public boolean voiceSupported;
        public boolean deafened;

        public PlayerState(boolean bl, boolean bl2) {
            this.voiceSupported = bl;
            this.deafened = bl2;
        }
    }
}

