/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PresenceUpdatePacket
extends UdpPacket {
    private int playerNetworkId;
    private boolean voiceSupported;
    private boolean deafened;

    public PresenceUpdatePacket() {
        super(UdpPacket.PacketType.PRESENCE_UPDATE);
    }

    public PresenceUpdatePacket(int n, boolean bl, boolean bl2) {
        super(UdpPacket.PacketType.PRESENCE_UPDATE);
        this.playerNetworkId = n;
        this.voiceSupported = bl;
        this.deafened = bl2;
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.playerNetworkId);
        dataOutputStream.writeBoolean(this.voiceSupported);
        dataOutputStream.writeBoolean(this.deafened);
    }

    public static PresenceUpdatePacket read(DataInputStream dataInputStream) throws IOException {
        PresenceUpdatePacket presenceUpdatePacket = new PresenceUpdatePacket();
        presenceUpdatePacket.playerNetworkId = dataInputStream.readInt();
        presenceUpdatePacket.voiceSupported = dataInputStream.readBoolean();
        presenceUpdatePacket.deafened = dataInputStream.readBoolean();
        return presenceUpdatePacket;
    }

    public int getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public boolean isVoiceSupported() {
        return this.voiceSupported;
    }

    public boolean isDeafened() {
        return this.deafened;
    }
}

