/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.GroupCreatePacket;
import com.moyettes.voice.udp.GroupDataPacket;
import com.moyettes.voice.udp.GroupJoinPacket;
import com.moyettes.voice.udp.GroupLeavePacket;
import com.moyettes.voice.udp.GroupListPacket;
import com.moyettes.voice.udp.GroupMemberUpdatePacket;
import com.moyettes.voice.udp.PingPacket;
import com.moyettes.voice.udp.PresenceBulkPacket;
import com.moyettes.voice.udp.PresenceUpdatePacket;
import com.moyettes.voice.udp.VoiceDataPacket;
import com.moyettes.voice.udp.VoiceDataRelayPacket;
import com.moyettes.voice.udp.VoiceHandshakeAckPacket;
import com.moyettes.voice.udp.VoiceHandshakePacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class UdpPacket {
    private final PacketType type;

    protected UdpPacket(PacketType packetType) {
        this.type = packetType;
    }

    public PacketType getType() {
        return this.type;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(this.type.getId());
        this.writeData(dataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static UdpPacket fromBytes(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            throw new IOException("Cannot parse null or empty packet data");
        }
        if (byArray.length < 1) {
            throw new IOException("Packet too short to contain type byte");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        byte by = dataInputStream.readByte();
        PacketType packetType = PacketType.fromId(by);
        if (packetType == null) {
            throw new IOException("Unknown packet type ID: " + by);
        }
        switch (packetType.ordinal()) {
            case 0: {
                return VoiceHandshakePacket.read(dataInputStream);
            }
            case 1: {
                return VoiceHandshakeAckPacket.read(dataInputStream);
            }
            case 2: {
                return VoiceDataPacket.read(dataInputStream);
            }
            case 3: {
                return VoiceDataRelayPacket.read(dataInputStream);
            }
            case 4: {
                return GroupCreatePacket.read(dataInputStream);
            }
            case 5: {
                return GroupJoinPacket.read(dataInputStream);
            }
            case 6: {
                return GroupLeavePacket.read(dataInputStream);
            }
            case 7: {
                return GroupListPacket.read(dataInputStream);
            }
            case 8: {
                return GroupDataPacket.read(dataInputStream);
            }
            case 9: {
                return GroupMemberUpdatePacket.read(dataInputStream);
            }
            case 10: {
                return PingPacket.read(dataInputStream);
            }
            case 11: {
                return PresenceUpdatePacket.read(dataInputStream);
            }
            case 12: {
                return PresenceBulkPacket.read(dataInputStream);
            }
        }
        throw new IllegalArgumentException("Unknown packet type: " + (Object)((Object)packetType));
    }

    protected abstract void writeData(DataOutputStream var1) throws IOException;

    public static enum PacketType {
        VOICE_HANDSHAKE(1),
        VOICE_HANDSHAKE_ACK(2),
        VOICE_DATA(3),
        VOICE_DATA_RELAY(4),
        GROUP_CREATE(5),
        GROUP_JOIN(6),
        GROUP_LEAVE(7),
        GROUP_LIST(8),
        GROUP_DATA(9),
        GROUP_MEMBER_UPDATE(10),
        PING(11),
        PRESENCE_UPDATE(12),
        PRESENCE_BULK(13);

        private final int id;

        private PacketType(int n2) {
            this.id = n2;
        }

        public int getId() {
            return this.id;
        }

        public static PacketType fromId(int n) {
            for (PacketType packetType : PacketType.values()) {
                if (packetType.id != n) continue;
                return packetType;
            }
            throw new IllegalArgumentException("Unknown packet type: " + n);
        }
    }
}

