/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class VoiceDataPacket
extends UdpPacket {
    private Integer playerNetworkId;
    private byte[] audioData;
    private long sequenceNumber;

    public VoiceDataPacket() {
        super(UdpPacket.PacketType.VOICE_DATA);
    }

    public VoiceDataPacket(Integer n, byte[] byArray, long l) {
        super(UdpPacket.PacketType.VOICE_DATA);
        this.playerNetworkId = n;
        this.audioData = byArray;
        this.sequenceNumber = l;
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.playerNetworkId);
        dataOutputStream.writeLong(this.sequenceNumber);
        dataOutputStream.writeInt(this.audioData.length);
        dataOutputStream.write(this.audioData);
    }

    public static VoiceDataPacket read(DataInputStream dataInputStream) throws IOException {
        VoiceDataPacket voiceDataPacket = new VoiceDataPacket();
        voiceDataPacket.playerNetworkId = dataInputStream.readInt();
        voiceDataPacket.sequenceNumber = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        if (n < 0 || n > 1024) {
            throw new IOException("Invalid audio data length: " + n);
        }
        voiceDataPacket.audioData = new byte[n];
        try {
            dataInputStream.readFully(voiceDataPacket.audioData);
        }
        catch (EOFException eOFException) {
            throw new IOException("Insufficient data in packet: expected " + n + " bytes", eOFException);
        }
        return voiceDataPacket;
    }

    public Integer getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public byte[] getAudioData() {
        return this.audioData;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

