/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class VoiceDataRelayPacket
extends UdpPacket {
    private Integer fromPlayerNetworkId;
    private byte[] audioData;
    private long sequenceNumber;
    private double distance;
    private float volume;
    private double playerX;
    private double playerY;
    private double playerZ;

    public VoiceDataRelayPacket() {
        super(UdpPacket.PacketType.VOICE_DATA_RELAY);
    }

    public VoiceDataRelayPacket(Integer n, byte[] byArray, long l, double d, float f, double d2, double d3, double d4) {
        super(UdpPacket.PacketType.VOICE_DATA_RELAY);
        this.fromPlayerNetworkId = n;
        this.audioData = byArray;
        this.sequenceNumber = l;
        this.distance = d;
        this.volume = f;
        this.playerX = d2;
        this.playerY = d3;
        this.playerZ = d4;
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.fromPlayerNetworkId);
        dataOutputStream.writeLong(this.sequenceNumber);
        dataOutputStream.writeDouble(this.distance);
        dataOutputStream.writeFloat(this.volume);
        dataOutputStream.writeDouble(this.playerX);
        dataOutputStream.writeDouble(this.playerY);
        dataOutputStream.writeDouble(this.playerZ);
        dataOutputStream.writeInt(this.audioData.length);
        dataOutputStream.write(this.audioData);
    }

    public static VoiceDataRelayPacket read(DataInputStream dataInputStream) throws IOException {
        VoiceDataRelayPacket voiceDataRelayPacket = new VoiceDataRelayPacket();
        voiceDataRelayPacket.fromPlayerNetworkId = dataInputStream.readInt();
        voiceDataRelayPacket.sequenceNumber = dataInputStream.readLong();
        voiceDataRelayPacket.distance = dataInputStream.readDouble();
        voiceDataRelayPacket.volume = dataInputStream.readFloat();
        voiceDataRelayPacket.playerX = dataInputStream.readDouble();
        voiceDataRelayPacket.playerY = dataInputStream.readDouble();
        voiceDataRelayPacket.playerZ = dataInputStream.readDouble();
        int n = dataInputStream.readInt();
        if (n < 0 || n > 1024) {
            throw new IOException("Invalid audio data length: " + n);
        }
        voiceDataRelayPacket.audioData = new byte[n];
        try {
            dataInputStream.readFully(voiceDataRelayPacket.audioData);
        }
        catch (EOFException eOFException) {
            throw new IOException("Insufficient data in packet: expected " + n + " bytes", eOFException);
        }
        return voiceDataRelayPacket;
    }

    public Integer getFromPlayerNetworkId() {
        return this.fromPlayerNetworkId;
    }

    public byte[] getAudioData() {
        return this.audioData;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public double getDistance() {
        return this.distance;
    }

    public float getVolume() {
        return this.volume;
    }

    public double getPlayerX() {
        return this.playerX;
    }

    public double getPlayerY() {
        return this.playerY;
    }

    public double getPlayerZ() {
        return this.playerZ;
    }
}

