/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VoiceHandshakePacket
extends UdpPacket {
    private Integer playerNetworkId;
    private String authToken;
    private boolean micEnabled;

    public VoiceHandshakePacket() {
        super(UdpPacket.PacketType.VOICE_HANDSHAKE);
    }

    public VoiceHandshakePacket(Integer n, String string, boolean bl) {
        super(UdpPacket.PacketType.VOICE_HANDSHAKE);
        this.playerNetworkId = n;
        this.authToken = string;
        this.micEnabled = bl;
    }

    @Override
    protected void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.playerNetworkId);
        dataOutputStream.writeUTF(this.authToken);
        dataOutputStream.writeBoolean(this.micEnabled);
    }

    public static VoiceHandshakePacket read(DataInputStream dataInputStream) throws IOException {
        VoiceHandshakePacket voiceHandshakePacket = new VoiceHandshakePacket();
        voiceHandshakePacket.playerNetworkId = dataInputStream.readInt();
        voiceHandshakePacket.authToken = dataInputStream.readUTF();
        voiceHandshakePacket.micEnabled = dataInputStream.readBoolean();
        return voiceHandshakePacket;
    }

    public Integer getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public boolean isMicEnabled() {
        return this.micEnabled;
    }
}

