/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.utils;

public class AudioUtils {
    public static short[] bytesToShorts(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i < byArray.length; i += 2) {
            sArray[i / 2] = AudioUtils.bytesToShort(byArray[i], byArray[i + 1]);
        }
        return sArray;
    }

    public static byte[] shortsToBytes(short[] sArray) {
        byte[] byArray = new byte[sArray.length * 2];
        for (int i = 0; i < byArray.length; i += 2) {
            byte[] byArray2 = AudioUtils.shortToBytes(sArray[i / 2]);
            byArray[i] = byArray2[0];
            byArray[i + 1] = byArray2[1];
        }
        return byArray;
    }

    public static float[] bytesToFloats(byte[] byArray) {
        float[] fArray = new float[byArray.length / 2];
        for (int i = 0; i < byArray.length; i += 2) {
            fArray[i / 2] = (float)AudioUtils.bytesToShort(byArray[i], byArray[i + 1]) / 32768.0f;
        }
        return fArray;
    }

    public static byte[] floatsToBytes(float[] fArray) {
        byte[] byArray = new byte[fArray.length * 2];
        for (int i = 0; i < byArray.length; i += 2) {
            short s2 = (short)(fArray[i / 2] * 32768.0f);
            byArray[i] = (byte)s2;
            byArray[i + 1] = (byte)(s2 >> 8);
        }
        return byArray;
    }

    public static short bytesToShort(byte by, byte by2) {
        return (short)((by2 & 0xFF) << 8 | by & 0xFF);
    }

    public static byte[] shortToBytes(short s2) {
        return new byte[]{(byte)(s2 & 0xFF), (byte)(s2 >> 8 & 0xFF)};
    }

    public static float mulToDB(float f) {
        return f == 0.0f ? -3.4028235E38f : (float)(20.0 * Math.log10(f));
    }

    public static float dbToMul(float f) {
        return Float.isFinite(f) ? (float)Math.pow(10.0, f / 20.0f) : 0.0f;
    }

    public static float gainCoefficient(int n, float f) {
        return (float)Math.exp(-1.0f / ((float)n * f));
    }

    public static int getActivationOffset(byte[] byArray, double d) {
        int n = -1;
        for (int i = 0; i < byArray.length; i += 100) {
            double d2 = AudioUtils.calculateAudioLevel(byArray, i, Math.min(i + 100, byArray.length));
            if (!(d2 >= d)) continue;
            n = i;
        }
        return n;
    }

    public static double getHighestAudioLevel(byte[] byArray) {
        double d = -127.0;
        for (int i = 0; i < byArray.length; i += 100) {
            double d2 = AudioUtils.calculateAudioLevel(byArray, i, Math.min(i + 100, byArray.length));
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double calculateAudioLevel(byte[] byArray, int n, int n2) {
        double d;
        int n3;
        double d2 = 0.0;
        for (n3 = n; n3 < n2; n3 += 2) {
            d = (double)AudioUtils.bytesToShort(byArray[n3], byArray[n3 + 1]) / 32767.0;
            d2 += d * d;
        }
        n3 = n2 / 2;
        d2 = n3 == 0 ? 0.0 : Math.sqrt(d2 / (double)n3);
        d = d2 > 0.0 ? Math.min(Math.max(20.0 * Math.log10(d2), -127.0), 0.0) : -127.0;
        return d;
    }
}

