/*
 * Decompiled with CFR 0.152.
 */
import com.moyettes.voice.api.client.ClientConnectionEvents;
import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.events.ClientEvents;
import com.moyettes.voice.events.KeyEvents;
import com.moyettes.voice.events.RenderEvents;
import com.moyettes.voice.gui.GroupMembersScreen;
import com.moyettes.voice.gui.GroupsScreen;
import com.moyettes.voice.packet.ClientPlayNetworking;
import com.moyettes.voice.packet.HandshakePayload;
import com.moyettes.voice.packet.VoiceModSupportedPayload;
import com.moyettes.voice.packet.VoiceServerInfoPayload;
import com.moyettes.voice.utils.MinecraftAccessor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class mod_Voice
extends BaseMod {
    public static final Logger LOGGER = LogManager.getLogger("Voice Mod");
    private static VoiceClient voiceClient;
    private static final String PROTOCOL_VERSION = "1.0.0";
    private static final boolean MIC_ENABLED = true;
    public static KeyEvents keyEvents;

    public mod_Voice() {
        ModLoader.SetInGameHook((BaseMod)this, (boolean)true, (boolean)false);
        MinecraftAccessor.setInstance(ModLoader.getMinecraftInstance());
        System.out.println("Initializing voice mod!");
        mod_Voice.registerNetworkListeners();
        new ClientEvents();
        new RenderEvents();
        keyEvents = new KeyEvents(this);
    }

    @Override
    public void KeyboardEvent(qb qb2) {
        ClientEvents.INSTANCE.onInput(qb2);
    }

    @Override
    public boolean OnTickInGame(Minecraft minecraft) {
        ClientEvents.INSTANCE.onRenderHUD();
        return true;
    }

    @Override
    public boolean OnTickInGame(Minecraft minecraft, da da2) {
        return false;
    }

    @Override
    public String Version() {
        return "0.1.0";
    }

    private static void registerNetworkListeners() {
        ClientPlayNetworking.registerListener("voice|server_info", VoiceServerInfoPayload::new, (minecraft, nb2, voiceServerInfoPayload) -> {
            System.out.println("Received voice server info - Port: " + voiceServerInfoPayload.getVoiceServerPort() + ", Protocol: " + voiceServerInfoPayload.getProtocolVersion());
            mod_Voice.connectToVoiceServer(voiceServerInfoPayload, minecraft);
            return true;
        });
        ClientPlayNetworking.registerListener("OSL|Handshake", HandshakePayload::new, (minecraft, nb2, handshakePayload) -> {
            ClientPlayNetworking.send("OSL|Handshake", HandshakePayload.client());
            ClientConnectionEvents.PLAY_READY.invoker().accept(minecraft);
            return true;
        });
        ClientConnectionEvents.PLAY_READY.register(minecraft -> {
            System.out.println("Connected to server, sending voice mod support");
            VoiceModSupportedPayload voiceModSupportedPayload = new VoiceModSupportedPayload(PROTOCOL_VERSION);
            ClientPlayNetworking.send("voice|mod_supported", voiceModSupportedPayload);
        });
        ClientConnectionEvents.DISCONNECT.register(minecraft -> {
            if (voiceClient == null) {
                return;
            }
            voiceClient.disconnect();
        });
    }

    private static void connectToVoiceServer(VoiceServerInfoPayload voiceServerInfoPayload, Minecraft minecraft) {
        try {
            Integer n = mod_Voice.getPlayerNetworkId(minecraft);
            voiceClient = new VoiceClient(n, true);
            voiceClient.setHandshakeCallback(voiceHandshakeAckPacket -> {
                if (!voiceHandshakeAckPacket.isSuccess()) {
                    LOGGER.warn("Failed to connect to voice server: " + voiceHandshakeAckPacket.getMessage());
                } else {
                    mod_Voice.startListenerPositionUpdater(minecraft);
                }
            });
            String string = voiceServerInfoPayload.getServerHost();
            if ("0.0.0.0".equals(string)) {
                try {
                    InetAddress inetAddress = mod_Voice.resolveServerHostFromConnection(minecraft);
                    string = inetAddress instanceof Inet4Address && !inetAddress.isLoopbackAddress() ? inetAddress.getHostAddress() : "127.0.0.1";
                }
                catch (Exception exception) {
                    LOGGER.warn("Could not resolve 0.0.0.0, using localhost: " + exception.getMessage());
                    string = "127.0.0.1";
                }
            }
            voiceClient.setGroupListCallback(groupListPacket -> GroupsScreen.updateCurrentGroupList(groupListPacket.getGroups()));
            voiceClient.setGroupMemberCallback(list -> GroupMembersScreen.updateCurrentMemberList(list));
            voiceClient.connect(string, voiceServerInfoPayload.getVoiceServerPort(), voiceServerInfoPayload.getAuthToken());
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to connect to voice server: " + iOException.getMessage());
        }
    }

    private static InetAddress resolveServerHostFromConnection(Minecraft minecraft) {
        nb nb2 = minecraft.s();
        if (nb2 == null) {
            throw new IllegalStateException("No network handler");
        }
        pf pf2 = nb2.e;
        if (pf2 == null) {
            throw new IllegalStateException("No connection");
        }
        SocketAddress socketAddress = pf2.i;
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalStateException("Not an InetSocketAddress");
        }
        return ((InetSocketAddress)socketAddress).getAddress();
    }

    private static Integer getPlayerNetworkId(Minecraft minecraft) {
        try {
            if (minecraft != null && minecraft.h != null) {
                return minecraft.h.aD;
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to get player network ID: " + exception.getMessage());
        }
        return 12345;
    }

    public static VoiceClient getVoiceClient() {
        return voiceClient;
    }

    public static void createGroup(String string, String string2) {
        if (voiceClient != null) {
            voiceClient.createGroup(string, string2);
        } else {
            System.out.println("Cannot create group: voice client not connected");
        }
    }

    public static void joinGroup(String string, String string2) {
        if (voiceClient != null) {
            voiceClient.joinGroup(string, string2);
        } else {
            System.out.println("Cannot join group: voice client not connected");
        }
    }

    public static void leaveGroup() {
        if (voiceClient != null) {
            voiceClient.leaveGroup();
        } else {
            System.out.println("Cannot leave group: voice client not connected");
        }
    }

    public static void requestGroupList() {
        if (voiceClient != null) {
            voiceClient.requestGroupList();
        } else {
            System.out.println("Cannot request group list: voice client not connected");
        }
    }

    public static boolean isInGroup() {
        return voiceClient != null && voiceClient.isInGroup();
    }

    public static String getCurrentGroupName() {
        return voiceClient != null ? voiceClient.getCurrentGroupName() : null;
    }

    public static void forceDisconnect() {
        if (voiceClient != null) {
            voiceClient.disconnect();
            voiceClient = null;
        }
    }

    private static void startListenerPositionUpdater(Minecraft minecraft) {
        Thread thread = new Thread(() -> {
            while (voiceClient != null && voiceClient.isConnected()) {
                try {
                    if (minecraft.h != null) {
                        float f;
                        double d = minecraft.h.aM;
                        double d2 = minecraft.h.aN;
                        double d3 = minecraft.h.aO;
                        float f2 = minecraft.h.aT;
                        for (f = minecraft.h.aS; f < 0.0f; f += 360.0f) {
                        }
                        while (f >= 360.0f) {
                            f -= 360.0f;
                        }
                        voiceClient.updateListenerPosition(d, d2, d3, f, f2);
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (Exception exception) {
                    LOGGER.error("Error updating listener position: " + exception.getMessage());
                }
            }
        }, "VoiceListenerPositionUpdater");
        thread.setDaemon(true);
        thread.start();
    }
}

