/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.List;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.pattern.TextRenderer;

class ThrowableProxyRenderer {
    private static final String TAB = "\t";
    private static final String CAUSED_BY_LABEL = "Caused by: ";
    private static final String SUPPRESSED_LABEL = "Suppressed: ";
    private static final String WRAPPED_BY_LABEL = "Wrapped by: ";

    private ThrowableProxyRenderer() {
    }

    static void formatWrapper(StringBuilder sb2, ThrowableProxy cause, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        Throwable caused;
        Throwable throwable = caused = cause.getCauseProxy() != null ? cause.getCauseProxy().getThrowable() : null;
        if (caused != null) {
            ThrowableProxyRenderer.formatWrapper(sb2, cause.getCauseProxy(), ignorePackages, textRenderer, suffix, lineSeparator);
            sb2.append(WRAPPED_BY_LABEL);
            ThrowableProxyRenderer.renderSuffix(suffix, sb2, textRenderer);
        }
        ThrowableProxyRenderer.renderOn(cause, sb2, textRenderer);
        ThrowableProxyRenderer.renderSuffix(suffix, sb2, textRenderer);
        textRenderer.render(lineSeparator, sb2, "Text");
        ThrowableProxyRenderer.formatElements(sb2, "", cause.getCommonElementCount(), cause.getThrowable().getStackTrace(), cause.getExtendedStackTrace(), ignorePackages, textRenderer, suffix, lineSeparator);
    }

    private static void formatCause(StringBuilder sb2, String prefix, ThrowableProxy cause, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        ThrowableProxyRenderer.formatThrowableProxy(sb2, prefix, CAUSED_BY_LABEL, cause, ignorePackages, textRenderer, suffix, lineSeparator);
    }

    private static void formatThrowableProxy(StringBuilder sb2, String prefix, String causeLabel, ThrowableProxy throwableProxy, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        if (throwableProxy == null) {
            return;
        }
        textRenderer.render(prefix, sb2, "Prefix");
        textRenderer.render(causeLabel, sb2, "CauseLabel");
        ThrowableProxyRenderer.renderOn(throwableProxy, sb2, textRenderer);
        ThrowableProxyRenderer.renderSuffix(suffix, sb2, textRenderer);
        textRenderer.render(lineSeparator, sb2, "Text");
        ThrowableProxyRenderer.formatElements(sb2, prefix, throwableProxy.getCommonElementCount(), throwableProxy.getStackTrace(), throwableProxy.getExtendedStackTrace(), ignorePackages, textRenderer, suffix, lineSeparator);
        ThrowableProxyRenderer.formatSuppressed(sb2, prefix + TAB, throwableProxy.getSuppressedProxies(), ignorePackages, textRenderer, suffix, lineSeparator);
        ThrowableProxyRenderer.formatCause(sb2, prefix, throwableProxy.getCauseProxy(), ignorePackages, textRenderer, suffix, lineSeparator);
    }

    private static void formatSuppressed(StringBuilder sb2, String prefix, ThrowableProxy[] suppressedProxies, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        if (suppressedProxies == null) {
            return;
        }
        for (ThrowableProxy suppressedProxy : suppressedProxies) {
            ThrowableProxyRenderer.formatThrowableProxy(sb2, prefix, SUPPRESSED_LABEL, suppressedProxy, ignorePackages, textRenderer, suffix, lineSeparator);
        }
    }

    private static void formatElements(StringBuilder sb2, String prefix, int commonCount, StackTraceElement[] causedTrace, ExtendedStackTraceElement[] extStackTrace, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        if (ignorePackages == null || ignorePackages.isEmpty()) {
            for (ExtendedStackTraceElement element : extStackTrace) {
                ThrowableProxyRenderer.formatEntry(element, sb2, prefix, textRenderer, suffix, lineSeparator);
            }
        } else {
            int count = 0;
            for (int i = 0; i < extStackTrace.length; ++i) {
                if (!ThrowableProxyRenderer.ignoreElement(causedTrace[i], ignorePackages)) {
                    if (count > 0) {
                        ThrowableProxyRenderer.appendSuppressedCount(sb2, prefix, count, textRenderer, suffix, lineSeparator);
                        count = 0;
                    }
                    ThrowableProxyRenderer.formatEntry(extStackTrace[i], sb2, prefix, textRenderer, suffix, lineSeparator);
                    continue;
                }
                ++count;
            }
            if (count > 0) {
                ThrowableProxyRenderer.appendSuppressedCount(sb2, prefix, count, textRenderer, suffix, lineSeparator);
            }
        }
        if (commonCount != 0) {
            textRenderer.render(prefix, sb2, "Prefix");
            textRenderer.render("\t... ", sb2, "More");
            textRenderer.render(Integer.toString(commonCount), sb2, "More");
            textRenderer.render(" more", sb2, "More");
            ThrowableProxyRenderer.renderSuffix(suffix, sb2, textRenderer);
            textRenderer.render(lineSeparator, sb2, "Text");
        }
    }

    private static void renderSuffix(String suffix, StringBuilder sb2, TextRenderer textRenderer) {
        if (!suffix.isEmpty()) {
            textRenderer.render(" ", sb2, "Suffix");
            textRenderer.render(suffix, sb2, "Suffix");
        }
    }

    private static void appendSuppressedCount(StringBuilder sb2, String prefix, int count, TextRenderer textRenderer, String suffix, String lineSeparator) {
        textRenderer.render(prefix, sb2, "Prefix");
        if (count == 1) {
            textRenderer.render("\t... ", sb2, "Suppressed");
        } else {
            textRenderer.render("\t... suppressed ", sb2, "Suppressed");
            textRenderer.render(Integer.toString(count), sb2, "Suppressed");
            textRenderer.render(" lines", sb2, "Suppressed");
        }
        ThrowableProxyRenderer.renderSuffix(suffix, sb2, textRenderer);
        textRenderer.render(lineSeparator, sb2, "Text");
    }

    private static void formatEntry(ExtendedStackTraceElement extStackTraceElement, StringBuilder sb2, String prefix, TextRenderer textRenderer, String suffix, String lineSeparator) {
        textRenderer.render(prefix, sb2, "Prefix");
        textRenderer.render("\tat ", sb2, "At");
        extStackTraceElement.renderOn(sb2, textRenderer);
        ThrowableProxyRenderer.renderSuffix(suffix, sb2, textRenderer);
        textRenderer.render(lineSeparator, sb2, "Text");
    }

    private static boolean ignoreElement(StackTraceElement element, List<String> ignorePackages) {
        if (ignorePackages != null) {
            String className = element.getClassName();
            for (String pkg : ignorePackages) {
                if (!className.startsWith(pkg)) continue;
                return true;
            }
        }
        return false;
    }

    static void formatExtendedStackTraceTo(ThrowableProxy src, StringBuilder sb2, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        textRenderer.render(src.getName(), sb2, "Name");
        textRenderer.render(": ", sb2, "NameMessageSeparator");
        textRenderer.render(src.getMessage(), sb2, "Message");
        ThrowableProxyRenderer.renderSuffix(suffix, sb2, textRenderer);
        textRenderer.render(lineSeparator, sb2, "Text");
        StackTraceElement[] causedTrace = src.getThrowable() != null ? src.getThrowable().getStackTrace() : null;
        ThrowableProxyRenderer.formatElements(sb2, "", 0, causedTrace, src.getExtendedStackTrace(), ignorePackages, textRenderer, suffix, lineSeparator);
        ThrowableProxyRenderer.formatSuppressed(sb2, TAB, src.getSuppressedProxies(), ignorePackages, textRenderer, suffix, lineSeparator);
        ThrowableProxyRenderer.formatCause(sb2, "", src.getCauseProxy(), ignorePackages, textRenderer, suffix, lineSeparator);
    }

    static void formatCauseStackTrace(ThrowableProxy src, StringBuilder sb2, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        ThrowableProxy causeProxy = src.getCauseProxy();
        if (causeProxy != null) {
            ThrowableProxyRenderer.formatWrapper(sb2, causeProxy, ignorePackages, textRenderer, suffix, lineSeparator);
            sb2.append(WRAPPED_BY_LABEL);
            ThrowableProxyRenderer.renderSuffix(suffix, sb2, textRenderer);
        }
        ThrowableProxyRenderer.renderOn(src, sb2, textRenderer);
        ThrowableProxyRenderer.renderSuffix(suffix, sb2, textRenderer);
        textRenderer.render(lineSeparator, sb2, "Text");
        ThrowableProxyRenderer.formatElements(sb2, "", 0, src.getStackTrace(), src.getExtendedStackTrace(), ignorePackages, textRenderer, suffix, lineSeparator);
    }

    private static void renderOn(ThrowableProxy src, StringBuilder output, TextRenderer textRenderer) {
        String msg = src.getMessage();
        textRenderer.render(src.getName(), output, "Name");
        if (msg != null) {
            textRenderer.render(": ", output, "NameMessageSeparator");
            textRenderer.render(msg, output, "Message");
        }
    }
}

