/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;

enum MapMessageJsonFormatter {

    public static final int MAX_DEPTH = MapMessageJsonFormatter.readMaxDepth();
    private static final char DQUOTE = '\"';
    private static final char RBRACE = ']';
    private static final char LBRACE = '[';
    private static final char COMMA = ',';
    private static final char RCURLY = '}';
    private static final char LCURLY = '{';
    private static final char COLON = ':';

    private static int readMaxDepth() {
        int maxDepth = PropertiesUtil.getProperties().getIntegerProperty("log4j2.mapMessage.jsonFormatter.maxDepth", 8);
        if (maxDepth < 0) {
            throw new IllegalArgumentException("was expecting a positive maxDepth, found: " + maxDepth);
        }
        return maxDepth;
    }

    static void format(StringBuilder sb2, Object object) {
        MapMessageJsonFormatter.format(sb2, object, 0);
    }

    private static void format(StringBuilder sb2, Object object, int depth) {
        if (depth >= MAX_DEPTH) {
            throw new IllegalArgumentException("maxDepth has been exceeded");
        }
        if (object == null) {
            sb2.append("null");
        } else if (object instanceof IndexedStringMap) {
            IndexedStringMap map = (IndexedStringMap)object;
            MapMessageJsonFormatter.formatIndexedStringMap(sb2, map, depth);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            MapMessageJsonFormatter.formatMap(sb2, map, depth);
        } else if (object instanceof List) {
            List list = (List)object;
            MapMessageJsonFormatter.formatList(sb2, list, depth);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            MapMessageJsonFormatter.formatCollection(sb2, collection, depth);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            MapMessageJsonFormatter.formatNumber(sb2, number);
        } else if (object instanceof Boolean) {
            boolean booleanValue = (Boolean)object;
            MapMessageJsonFormatter.formatBoolean(sb2, booleanValue);
        } else if (object instanceof StringBuilderFormattable) {
            StringBuilderFormattable formattable = (StringBuilderFormattable)object;
            MapMessageJsonFormatter.formatFormattable(sb2, formattable);
        } else if (object instanceof char[]) {
            char[] charValues = (char[])object;
            MapMessageJsonFormatter.formatCharArray(sb2, charValues);
        } else if (object instanceof boolean[]) {
            boolean[] booleanValues = (boolean[])object;
            MapMessageJsonFormatter.formatBooleanArray(sb2, booleanValues);
        } else if (object instanceof byte[]) {
            byte[] byteValues = (byte[])object;
            MapMessageJsonFormatter.formatByteArray(sb2, byteValues);
        } else if (object instanceof short[]) {
            short[] shortValues = (short[])object;
            MapMessageJsonFormatter.formatShortArray(sb2, shortValues);
        } else if (object instanceof int[]) {
            int[] intValues = (int[])object;
            MapMessageJsonFormatter.formatIntArray(sb2, intValues);
        } else if (object instanceof long[]) {
            long[] longValues = (long[])object;
            MapMessageJsonFormatter.formatLongArray(sb2, longValues);
        } else if (object instanceof float[]) {
            float[] floatValues = (float[])object;
            MapMessageJsonFormatter.formatFloatArray(sb2, floatValues);
        } else if (object instanceof double[]) {
            double[] doubleValues = (double[])object;
            MapMessageJsonFormatter.formatDoubleArray(sb2, doubleValues);
        } else if (object instanceof Object[]) {
            Object[] objectValues = (Object[])object;
            MapMessageJsonFormatter.formatObjectArray(sb2, objectValues, depth);
        } else {
            MapMessageJsonFormatter.formatString(sb2, object);
        }
    }

    private static void formatIndexedStringMap(StringBuilder sb2, IndexedStringMap map, int depth) {
        sb2.append('{');
        int nextDepth = depth + 1;
        for (int entryIndex = 0; entryIndex < map.size(); ++entryIndex) {
            String key = map.getKeyAt(entryIndex);
            Object value = map.getValueAt(entryIndex);
            if (entryIndex > 0) {
                sb2.append(',');
            }
            sb2.append('\"');
            int keyStartIndex = sb2.length();
            sb2.append(key);
            StringBuilders.escapeJson(sb2, keyStartIndex);
            sb2.append('\"').append(':');
            MapMessageJsonFormatter.format(sb2, value, nextDepth);
        }
        sb2.append('}');
    }

    private static void formatMap(StringBuilder sb2, Map<Object, Object> map, int depth) {
        sb2.append('{');
        int nextDepth = depth + 1;
        boolean[] firstEntry = new boolean[]{true};
        map.forEach((key, value) -> {
            if (key == null) {
                throw new IllegalArgumentException("null keys are not allowed");
            }
            if (firstEntry[0]) {
                firstEntry[0] = false;
            } else {
                sb2.append(',');
            }
            sb2.append('\"');
            String keyString = String.valueOf(key);
            int keyStartIndex = sb2.length();
            sb2.append(keyString);
            StringBuilders.escapeJson(sb2, keyStartIndex);
            sb2.append('\"').append(':');
            MapMessageJsonFormatter.format(sb2, value, nextDepth);
        });
        sb2.append('}');
    }

    private static void formatList(StringBuilder sb2, List<Object> items, int depth) {
        sb2.append('[');
        int nextDepth = depth + 1;
        for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            Object item = items.get(itemIndex);
            MapMessageJsonFormatter.format(sb2, item, nextDepth);
        }
        sb2.append(']');
    }

    private static void formatCollection(StringBuilder sb2, Collection<Object> items, int depth) {
        sb2.append('[');
        int nextDepth = depth + 1;
        boolean[] firstItem = new boolean[]{true};
        items.forEach(item -> {
            if (firstItem[0]) {
                firstItem[0] = false;
            } else {
                sb2.append(',');
            }
            MapMessageJsonFormatter.format(sb2, item, nextDepth);
        });
        sb2.append(']');
    }

    private static void formatNumber(StringBuilder sb2, Number number) {
        if (number instanceof BigDecimal) {
            BigDecimal decimalNumber = (BigDecimal)number;
            sb2.append(decimalNumber.toString());
        } else if (number instanceof Double) {
            double doubleNumber = (Double)number;
            sb2.append(doubleNumber);
        } else if (number instanceof Float) {
            float floatNumber = ((Float)number).floatValue();
            sb2.append(floatNumber);
        } else if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            long longNumber = number.longValue();
            sb2.append(longNumber);
        } else {
            double doubleValue;
            long longNumber = number.longValue();
            if (Double.compare(longNumber, doubleValue = number.doubleValue()) == 0) {
                sb2.append(longNumber);
            } else {
                sb2.append(doubleValue);
            }
        }
    }

    private static void formatBoolean(StringBuilder sb2, boolean booleanValue) {
        sb2.append(booleanValue);
    }

    private static void formatFormattable(StringBuilder sb2, StringBuilderFormattable formattable) {
        sb2.append('\"');
        int startIndex = sb2.length();
        formattable.formatTo(sb2);
        StringBuilders.escapeJson(sb2, startIndex);
        sb2.append('\"');
    }

    private static void formatCharArray(StringBuilder sb2, char[] items) {
        sb2.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            char item = items[itemIndex];
            sb2.append('\"');
            int startIndex = sb2.length();
            sb2.append(item);
            StringBuilders.escapeJson(sb2, startIndex);
            sb2.append('\"');
        }
        sb2.append(']');
    }

    private static void formatBooleanArray(StringBuilder sb2, boolean[] items) {
        sb2.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            boolean item = items[itemIndex];
            sb2.append(item);
        }
        sb2.append(']');
    }

    private static void formatByteArray(StringBuilder sb2, byte[] items) {
        sb2.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            byte item = items[itemIndex];
            sb2.append(item);
        }
        sb2.append(']');
    }

    private static void formatShortArray(StringBuilder sb2, short[] items) {
        sb2.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            short item = items[itemIndex];
            sb2.append(item);
        }
        sb2.append(']');
    }

    private static void formatIntArray(StringBuilder sb2, int[] items) {
        sb2.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            int item = items[itemIndex];
            sb2.append(item);
        }
        sb2.append(']');
    }

    private static void formatLongArray(StringBuilder sb2, long[] items) {
        sb2.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            long item = items[itemIndex];
            sb2.append(item);
        }
        sb2.append(']');
    }

    private static void formatFloatArray(StringBuilder sb2, float[] items) {
        sb2.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            float item = items[itemIndex];
            sb2.append(item);
        }
        sb2.append(']');
    }

    private static void formatDoubleArray(StringBuilder sb2, double[] items) {
        sb2.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            double item = items[itemIndex];
            sb2.append(item);
        }
        sb2.append(']');
    }

    private static void formatObjectArray(StringBuilder sb2, Object[] items, int depth) {
        sb2.append('[');
        int nextDepth = depth + 1;
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb2.append(',');
            }
            Object item = items[itemIndex];
            MapMessageJsonFormatter.format(sb2, item, nextDepth);
        }
        sb2.append(']');
    }

    private static void formatString(StringBuilder sb2, Object value) {
        sb2.append('\"');
        int startIndex = sb2.length();
        String valueString = String.valueOf(value);
        sb2.append(valueString);
        StringBuilders.escapeJson(sb2, startIndex);
        sb2.append('\"');
    }
}

