/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio;

import com.moyettes.voice.Voice;
import com.moyettes.voice.audio.codec.NativeOpusDecoder;
import com.moyettes.voice.audio.codec.NativeOpusEncoder;
import com.moyettes.voice.audio.codec.OpusMode;
import com.moyettes.voice.audio.filter.AudioFilter;
import com.moyettes.voice.audio.filter.GainFilter;
import com.moyettes.voice.audio.filter.NoiseSuppressionFilter;
import com.moyettes.voice.audio.utils.AudioUtils;
import java.util.ArrayList;
import java.util.List;

public class AudioProcessor {
    private static final int SAMPLE_RATE = 48000;
    private static final int FRAME_SIZE_SAMPLES = 960;
    private static final int FRAME_SIZE = 1920;
    private static final int MAX_PAYLOAD_SIZE = 1024;
    private final byte[] encodeBuffer = new byte[3840];
    private final byte[] decodeBuffer = new byte[3840];
    private NativeOpusEncoder encoder;
    private NativeOpusDecoder decoder;
    private boolean initialized;
    private final Object encoderLock = new Object();
    private final Object decoderLock = new Object();
    private final List<AudioFilter> audioFilters = new ArrayList<AudioFilter>();
    private GainFilter gainFilter;
    private NoiseSuppressionFilter noiseFilter;

    public AudioProcessor() {
        try {
            this.encoder = new NativeOpusEncoder(48000, 1024, false, OpusMode.VOIP);
            this.decoder = new NativeOpusDecoder(48000, 960, false);
            this.encoder.initialize();
            this.decoder.initialize();
            this.initializeAudioFilters();
            boolean bl = this.initialized = this.encoder.isInitialized() && this.decoder.isInitialized();
            if (this.initialized) {
                Voice.LOGGER.info("Audio processor initialized");
            } else {
                Voice.LOGGER.warn("Failed to initialize native Opus libraries");
            }
        }
        catch (Exception e) {
            Voice.LOGGER.warn("Failed to initialize audio processor: " + e.getMessage());
            this.encoder = null;
            this.decoder = null;
            this.initialized = false;
        }
    }

    private void initializeAudioFilters() {
        this.gainFilter = new GainFilter(1.0f);
        this.noiseFilter = new NoiseSuppressionFilter(false);
        this.audioFilters.add(this.gainFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeAudio(byte[] rawAudio) {
        if (rawAudio == null || rawAudio.length == 0) {
            return null;
        }
        if (rawAudio.length != 1920 && rawAudio.length % 2 != 0) {
            Voice.LOGGER.warn("Invalid frame size for encoding: " + rawAudio.length + " bytes (not even, expected " + 1920 + ")");
            return null;
        }
        if (!this.initialized || this.encoder == null || !this.encoder.isInitialized()) {
            Voice.LOGGER.warn("Native Opus encoder not available");
            return null;
        }
        Object object = this.encoderLock;
        synchronized (object) {
            try {
                short[] samples = AudioUtils.bytesToShorts(rawAudio);
                samples = this.processAudioPipeline(samples);
                byte[] encoded = this.encoder.encode(samples);
                if (encoded == null || encoded.length == 0) {
                    Voice.LOGGER.warn("Native Opus encoding returned null/empty - NOT sending audio");
                    return null;
                }
                return encoded;
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Failed to encode audio with native Opus: " + e.getMessage());
                return null;
            }
        }
    }

    private short[] processAudioPipeline(short[] samples) {
        short[] processed = samples;
        for (AudioFilter filter : this.audioFilters) {
            if (!filter.isEnabled()) continue;
            processed = filter.process(processed);
        }
        return processed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decodeAudio(byte[] opusData) {
        if (!this.initialized || this.decoder == null || !this.decoder.isInitialized()) {
            Voice.LOGGER.warn("Native Opus decoder not available - NOT playing audio");
            return null;
        }
        Object object = this.decoderLock;
        synchronized (object) {
            try {
                short[] decodedSamples = this.decoder.decode(opusData);
                if (decodedSamples == null || decodedSamples.length == 0) {
                    Voice.LOGGER.warn("Native Opus decoding returned null/empty - NOT playing audio");
                    return null;
                }
                return AudioUtils.shortsToBytes(decodedSamples);
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Failed to decode audio with native Opus: " + e.getMessage());
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decodeSilence() {
        if (!this.initialized || this.decoder == null || !this.decoder.isInitialized()) {
            return null;
        }
        Object object = this.decoderLock;
        synchronized (object) {
            try {
                short[] silenceSamples = this.decoder.decodeSilence();
                if (silenceSamples == null || silenceSamples.length == 0) {
                    return null;
                }
                return AudioUtils.shortsToBytes(silenceSamples);
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Failed to decode silence with native Opus: " + e.getMessage());
                return null;
            }
        }
    }

    public void setMicrophoneGain(float gain) {
        if (this.gainFilter != null) {
            this.gainFilter.setVolume(gain);
        }
    }

    public void setNoiseSuppression(boolean enabled) {
        if (this.noiseFilter != null && !enabled) {
            this.noiseFilter.close();
        }
    }

    public boolean isNoiseSuppressionEnabled() {
        return this.noiseFilter != null && this.noiseFilter.isEnabled();
    }

    public double getAudioLevel(byte[] audioData) {
        if (audioData == null || audioData.length == 0) {
            return -127.0;
        }
        return AudioUtils.getHighestAudioLevel(audioData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.initialized) {
            Object object = this.encoderLock;
            synchronized (object) {
                if (this.encoder != null) {
                    this.encoder.reset();
                }
            }
            object = this.decoderLock;
            synchronized (object) {
                if (this.decoder != null) {
                    this.decoder.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.initialized) {
            Object object = this.encoderLock;
            synchronized (object) {
                if (this.encoder != null) {
                    this.encoder.close();
                }
            }
            object = this.decoderLock;
            synchronized (object) {
                if (this.decoder != null) {
                    this.decoder.close();
                }
            }
            if (this.noiseFilter != null) {
                this.noiseFilter.close();
            }
            this.initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEncoder() {
        if (this.initialized && this.encoder != null) {
            Object object = this.encoderLock;
            synchronized (object) {
                this.encoder.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDecoder() {
        if (this.initialized && this.decoder != null) {
            Object object = this.decoderLock;
            synchronized (object) {
                this.decoder.reset();
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static int getSampleRate() {
        return 48000;
    }

    public static int getFrameSize() {
        return 1920;
    }
}

