/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio;

import com.moyettes.voice.Voice;
import java.util.function.Consumer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class MicrophoneCapture
implements Runnable {
    private static final float SAMPLE_RATE = 48000.0f;
    private static final int SAMPLE_SIZE_IN_BITS = 16;
    private static final int CHANNELS = 1;
    private static final boolean BIG_ENDIAN = false;
    private TargetDataLine microphone;
    private volatile boolean running;
    private Thread captureThread;
    private Consumer<byte[]> audioDataConsumer;
    private String preferredDeviceName;

    public MicrophoneCapture(Consumer<byte[]> audioDataConsumer) {
        this(audioDataConsumer, null);
    }

    public MicrophoneCapture(Consumer<byte[]> audioDataConsumer, String preferredDeviceName) {
        this.audioDataConsumer = audioDataConsumer;
        this.preferredDeviceName = preferredDeviceName;
    }

    public boolean startCapture() {
        if (this.running) {
            return true;
        }
        try {
            AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                Voice.LOGGER.warn("Audio format not supported");
                return false;
            }
            if (this.preferredDeviceName != null && !this.preferredDeviceName.isEmpty() && !"Default".equals(this.preferredDeviceName)) {
                Mixer.Info[] mixers = AudioSystem.getMixerInfo();
                TargetDataLine line = null;
                for (Mixer.Info mixerInfo : mixers) {
                    if (!this.preferredDeviceName.equals(mixerInfo.getName())) continue;
                    try {
                        Mixer mixer = AudioSystem.getMixer(mixerInfo);
                        Line.Info lineInfo = new Line.Info(TargetDataLine.class);
                        line = (TargetDataLine)mixer.getLine(lineInfo);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (line != null) {
                    this.microphone = line;
                }
            }
            if (this.microphone == null) {
                DataLine.Info anyFormat = new DataLine.Info(TargetDataLine.class, null);
                this.microphone = (TargetDataLine)AudioSystem.getLine(anyFormat);
            }
            int internalBufferBytes = 61440;
            this.microphone.open(format, internalBufferBytes);
            this.microphone.start();
            this.running = true;
            this.captureThread = new Thread((Runnable)this, "MicrophoneCaptureThread");
            this.captureThread.setDaemon(true);
            this.captureThread.start();
            return true;
        }
        catch (LineUnavailableException e) {
            Voice.LOGGER.warn("Microphone line unavailable: " + e.getMessage());
            return false;
        }
    }

    public void stopCapture() {
        this.running = false;
        if (this.captureThread != null) {
            try {
                this.captureThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Voice.LOGGER.info("Microphone capture stopped.");
    }

    public void close() {
        this.stopCapture();
        if (this.microphone != null) {
            this.microphone.stop();
            this.microphone.close();
            this.microphone = null;
            Voice.LOGGER.info("Microphone closed.");
        }
    }

    @Override
    public void run() {
        int frameBytes = 1920;
        byte[] frameBuffer = new byte[1920];
        int frameOffset = 0;
        byte[] readBuffer = new byte[4096];
        Voice.LOGGER.info("Audio capture thread started");
        while (this.running) {
            try {
                int bytesRead = this.microphone.read(readBuffer, 0, readBuffer.length);
                if (bytesRead <= 0) continue;
                int srcPos = 0;
                while (srcPos < bytesRead) {
                    int remainingInFrame = 1920 - frameOffset;
                    int toCopy = Math.min(remainingInFrame, bytesRead - srcPos);
                    System.arraycopy(readBuffer, srcPos, frameBuffer, frameOffset, toCopy);
                    srcPos += toCopy;
                    if ((frameOffset += toCopy) != 1920) continue;
                    if (this.audioDataConsumer != null) {
                        byte[] frameCopy = new byte[1920];
                        System.arraycopy(frameBuffer, 0, frameCopy, 0, 1920);
                        this.audioDataConsumer.accept(frameCopy);
                    }
                    frameOffset = 0;
                }
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Error in audio capture: " + e.getMessage());
                break;
            }
        }
    }
}

