/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.filter;

import com.moyettes.voice.Voice;
import com.moyettes.voice.audio.filter.AudioFilter;
import com.moyettes.voice.audio.filter.LimiterFilter;
import com.moyettes.voice.audio.utils.AudioUtils;
import com.plasmoverse.rnnoise.Denoise;
import com.plasmoverse.rnnoise.DenoiseException;

public class NoiseSuppressionFilter
implements AudioFilter {
    private final boolean enabled;
    private final LimiterFilter limiter;
    private Denoise rnnoiseInstance;

    public NoiseSuppressionFilter(boolean enabled) {
        this.enabled = enabled;
        this.limiter = new LimiterFilter(48000, -6.0f);
        if (enabled) {
            try {
                this.rnnoiseInstance = Denoise.create();
                Voice.LOGGER.info("Plasmo Voice RNNoise noise suppression enabled with built-in limiter");
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Plasmo Voice RNNoise not available, noise suppression disabled: " + e.getMessage());
                this.rnnoiseInstance = null;
            }
        }
    }

    @Override
    public String getName() {
        return "noise_suppression";
    }

    @Override
    public short[] process(short[] samples) {
        this.limiter.process(samples);
        if (!this.enabled || this.rnnoiseInstance == null) {
            return samples;
        }
        try {
            float[] floatSamples = AudioUtils.shortsToFloatsRange(samples);
            float[] processed = this.rnnoiseInstance.process(floatSamples);
            return AudioUtils.floatsRangeToShort(processed);
        }
        catch (DenoiseException e) {
            Voice.LOGGER.warn("Noise suppression failed: " + e.getMessage());
            return samples;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.rnnoiseInstance != null;
    }

    @Override
    public int getSupportedChannels() {
        return 1;
    }

    public void close() {
        if (this.rnnoiseInstance != null) {
            try {
                this.rnnoiseInstance.getClass().getMethod("close", new Class[0]).invoke((Object)this.rnnoiseInstance, new Object[0]);
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Error closing RNNoise instance: " + e.getMessage());
            }
            this.rnnoiseInstance = null;
        }
    }
}

