/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.events;

import com.moyettes.voice.Voice;
import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.events.ClientEvents;
import com.moyettes.voice.utils.MinecraftAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_7799337;
import net.minecraft.unmapped.C_9590849;
import org.lwjgl.opengl.GL11;

public class RenderEvents {
    private static final String MICROPHONE_ICON = "/assets/legacyvoicechat/textures/icons/microphone.png";
    private static final String MICROPHONE_MUTE_ICON = "/assets/legacyvoicechat/textures/icons/microphone_off.png";
    private static final String PLAYER_DISCONNECTED = "/assets/legacyvoicechat/textures/icons/player_disconnected.png";
    private static final String PLAYER_MUTED = "/assets/legacyvoicechat/textures/icons/player_muted.png";
    private static final String PLAYER_TALKING = "/assets/legacyvoicechat/textures/icons/player_talking.png";

    public RenderEvents() {
        ClientEvents.INSTANCE.registerRenderHUDEvent(this::onRenderHUD);
        ClientEvents.INSTANCE.registerRenderHUDEvent(this::onRenderHUD);
        ClientEvents.INSTANCE.registerRenderPlayerIconsEvent(this::onRenderPlayerIcons);
    }

    private void onRenderHUD(float tickDelta) {
        Minecraft minecraft = MinecraftAccessor.getMinecraft();
        if (minecraft == null) {
            return;
        }
        VoiceClient voiceClient = Voice.getVoiceClient();
        if (voiceClient == null) {
            this.renderHudIcon(minecraft, PLAYER_DISCONNECTED);
            return;
        }
        if (voiceClient.isDeafened()) {
            this.renderHudIcon(minecraft, PLAYER_MUTED);
        } else if (voiceClient.isMicMuted()) {
            this.renderHudIcon(minecraft, MICROPHONE_MUTE_ICON);
        } else if (voiceClient.isTalking()) {
            this.renderHudIcon(minecraft, MICROPHONE_ICON);
        }
    }

    private void onRenderPlayerIcons(C_9590849 player, double d, double e, double f) {
        VoiceClient voiceClient = Voice.getVoiceClient();
        if (voiceClient == null) {
            return;
        }
        if (voiceClient.isPlayerVoiceSupported(player)) {
            if (voiceClient.isPlayerDeafened(player)) {
                this.renderPlayerIconWithTexture(player, d, e, f, PLAYER_MUTED);
            } else if (voiceClient.isPlayerTalking(player)) {
                this.renderPlayerIcon(player, d, e, f);
            }
        } else {
            this.renderPlayerIconWithTexture(player, d, e, f, PLAYER_DISCONNECTED);
        }
    }

    private void renderPlayerIconWithTexture(C_9590849 player, double d, double e, double f, String texturePath) {
        Minecraft mc = MinecraftAccessor.getMinecraft();
        if (mc == null) {
            return;
        }
        double baseNameTagY = player.m_4153657() ? 2.1 : 2.3;
        double yOffset = baseNameTagY + 0.2;
        GL11.glPushMatrix();
        GL11.glTranslated((double)d, (double)(e + yOffset), (double)f);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-mc.f_6058446.f_7165431), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)mc.f_6058446.f_0243146, (float)1.0f, (float)0.0f, (float)0.0f);
        float scale = 0.013333335f;
        GL11.glScalef((float)-0.013333335f, (float)-0.013333335f, (float)0.013333335f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        int textureId = mc.f_9413506.m_9688911(texturePath);
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int iconSize = 16;
        int half = iconSize / 2;
        C_5786166 buffer = C_5786166.f_7436514;
        buffer.m_5815628();
        buffer.m_1165938((double)(-half), (double)(-half), 0.0, 0.0, 0.0);
        buffer.m_1165938((double)half, (double)(-half), 0.0, 1.0, 0.0);
        buffer.m_1165938((double)half, (double)half, 0.0, 1.0, 1.0);
        buffer.m_1165938((double)(-half), (double)half, 0.0, 0.0, 1.0);
        buffer.m_7459300();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    private void renderPlayerIcon(C_9590849 player, double d, double e, double f) {
        Minecraft mc = MinecraftAccessor.getMinecraft();
        if (mc == null) {
            return;
        }
        double baseNameTagY = player.m_4153657() ? 2.1 : 2.3;
        double yOffset = baseNameTagY + 0.2;
        GL11.glPushMatrix();
        GL11.glTranslated((double)d, (double)(e + yOffset), (double)f);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-mc.f_6058446.f_7165431), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)mc.f_6058446.f_0243146, (float)1.0f, (float)0.0f, (float)0.0f);
        float scale = 0.013333335f;
        GL11.glScalef((float)-0.013333335f, (float)-0.013333335f, (float)0.013333335f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        int textureId = mc.f_9413506.m_9688911(PLAYER_TALKING);
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int iconSize = 16;
        int half = iconSize / 2;
        C_5786166 buffer = C_5786166.f_7436514;
        buffer.m_5815628();
        buffer.m_1165938((double)(-half), (double)(-half), 0.0, 0.0, 0.0);
        buffer.m_1165938((double)half, (double)(-half), 0.0, 1.0, 0.0);
        buffer.m_1165938((double)half, (double)half, 0.0, 1.0, 1.0);
        buffer.m_1165938((double)(-half), (double)half, 0.0, 0.0, 1.0);
        buffer.m_7459300();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    private void renderHudIcon(Minecraft minecraft, String texturePath) {
        int padding;
        C_7799337 window = new C_7799337(minecraft.f_0545414, minecraft.f_5990000);
        int scaledHeight = window.m_5421693();
        int iconSize = 16;
        int x = padding = 8;
        int y = scaledHeight - iconSize - padding;
        GL11.glBindTexture((int)3553, (int)minecraft.f_9413506.m_9688911(texturePath));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        C_5786166 bufferBuilder = C_5786166.f_7436514;
        bufferBuilder.m_5815628();
        bufferBuilder.m_1165938((double)x, (double)(y + iconSize), 0.0, 0.0, 1.0);
        bufferBuilder.m_1165938((double)(x + iconSize), (double)(y + iconSize), 0.0, 1.0, 1.0);
        bufferBuilder.m_1165938((double)(x + iconSize), (double)y, 0.0, 1.0, 0.0);
        bufferBuilder.m_1165938((double)x, (double)y, 0.0, 0.0, 0.0);
        bufferBuilder.m_7459300();
        GL11.glDisable((int)3042);
    }
}

