/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.Voice;
import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.gui.CreateGroupScreen;
import com.moyettes.voice.gui.GroupMembersScreen;
import com.moyettes.voice.gui.GroupsScreen;
import com.moyettes.voice.gui.JoinGroupScreen;
import com.moyettes.voice.gui.PlayersScreen;
import com.moyettes.voice.gui.VoiceSettingsScreen;
import com.moyettes.voice.gui.widget.DisabledButtonWidget;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import org.lwjgl.opengl.GL11;

public abstract class BaseVoiceScreen
extends C_3020744 {
    protected int backgroundWidth = 176;
    protected int backgroundHeight = 222;
    private C_2348249 settingsTabButton;
    private C_2348249 groupsTabButton;
    private C_2348249 playersTabButton;

    public void m_3593494() {
        this.f_2213969.clear();
        this.initTabs();
        this.initContent();
    }

    protected void initTabs() {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        int tabY = backgroundY - 20;
        int tabWidth = 56;
        int tabHeight = 20;
        int tabStartX = backgroundX + 2;
        if (this instanceof VoiceSettingsScreen) {
            this.settingsTabButton = new DisabledButtonWidget(3000, tabStartX, tabY, tabWidth, tabHeight, "Settings");
            this.groupsTabButton = new C_2348249(3001, tabStartX + tabWidth, tabY, tabWidth, tabHeight, "Groups");
            this.playersTabButton = new C_2348249(3002, tabStartX + tabWidth * 2, tabY, tabWidth, tabHeight, "Players");
        } else if (this instanceof GroupsScreen || this instanceof CreateGroupScreen || this instanceof GroupMembersScreen || this instanceof JoinGroupScreen) {
            this.settingsTabButton = new C_2348249(3000, tabStartX, tabY, tabWidth, tabHeight, "Settings");
            this.groupsTabButton = new DisabledButtonWidget(3001, tabStartX + tabWidth, tabY, tabWidth, tabHeight, "Groups");
            this.playersTabButton = new C_2348249(3002, tabStartX + tabWidth * 2, tabY, tabWidth, tabHeight, "Players");
        } else if (this instanceof PlayersScreen) {
            this.settingsTabButton = new C_2348249(3000, tabStartX, tabY, tabWidth, tabHeight, "Settings");
            this.groupsTabButton = new C_2348249(3001, tabStartX + tabWidth, tabY, tabWidth, tabHeight, "Groups");
            this.playersTabButton = new DisabledButtonWidget(3002, tabStartX + tabWidth * 2, tabY, tabWidth, tabHeight, "Players");
        } else {
            this.settingsTabButton = new C_2348249(3000, tabStartX, tabY, tabWidth, tabHeight, "Settings");
            this.groupsTabButton = new C_2348249(3001, tabStartX + tabWidth, tabY, tabWidth, tabHeight, "Groups");
            this.playersTabButton = new C_2348249(3002, tabStartX + tabWidth * 2, tabY, tabWidth, tabHeight, "Players");
        }
        this.f_2213969.add(this.settingsTabButton);
        this.f_2213969.add(this.groupsTabButton);
        this.f_2213969.add(this.playersTabButton);
    }

    public void m_7261014(int mouseX, int mouseY, float tickDelta) {
        this.m_7817195();
        this.drawBackground(tickDelta);
        this.renderContent(mouseX, mouseY, tickDelta);
        super.m_7261014(mouseX, mouseY, tickDelta);
        this.drawForeground();
    }

    protected void drawBackground(float tickDelta) {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        int textureId = this.f_7153641.f_9413506.m_9688911(this.getBackgroundTexture());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_7153641.f_9413506.m_1620317(textureId);
        this.m_4354119(backgroundX, backgroundY, 0, 0, this.backgroundWidth, this.backgroundHeight);
    }

    protected void drawForeground() {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        String title = this.getTitle();
        int titleWidth = this.f_2020658.m_0040387(title);
        int titleX = backgroundX + (this.backgroundWidth - titleWidth) / 2;
        this.f_2020658.m_4683674(title, titleX, backgroundY + 6, 0x404040);
    }

    protected void m_7971793(C_2348249 button) {
        if (button.f_5920996 == 3000) {
            if (!(this instanceof VoiceSettingsScreen)) {
                this.f_7153641.m_6408915((C_3020744)new VoiceSettingsScreen());
            }
        } else if (button.f_5920996 == 3001) {
            if (!(this instanceof GroupsScreen || this instanceof GroupMembersScreen || this instanceof CreateGroupScreen || this instanceof JoinGroupScreen)) {
                VoiceClient vc = Voice.getVoiceClient();
                if (vc != null && vc.isInGroup()) {
                    this.f_7153641.m_6408915((C_3020744)new GroupMembersScreen());
                } else {
                    this.f_7153641.m_6408915((C_3020744)new GroupsScreen());
                }
            }
        } else if (button.f_5920996 == 3002) {
            if (!(this instanceof PlayersScreen)) {
                this.f_7153641.m_6408915((C_3020744)new PlayersScreen());
            }
        } else {
            this.handleCustomButtonClick(button);
        }
    }

    protected abstract void initContent();

    protected abstract void renderContent(int var1, int var2, float var3);

    protected abstract void handleCustomButtonClick(C_2348249 var1);

    protected abstract String getBackgroundTexture();

    protected abstract String getTitle();
}

