/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.Voice;
import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.GroupsScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import org.lwjgl.input.Mouse;

public class GroupMembersScreen
extends BaseVoiceScreen {
    private static final int ROW_HEIGHT = 24;
    private static final int BUTTON_HEIGHT = 20;
    private final List<MemberEntry> entries = new ArrayList<MemberEntry>();
    private int scrollOffset = 0;
    private List<String> groupMembers = new ArrayList<String>();
    private String currentGroupName = "";
    private static GroupMembersScreen currentInstance = null;

    @Override
    protected void initContent() {
        currentInstance = this;
        VoiceClient vc = Voice.getVoiceClient();
        if (vc != null) {
            this.currentGroupName = vc.getCurrentGroupName();
            this.groupMembers = new ArrayList<String>();
            for (Integer memberId : vc.getGroupMembers()) {
                String memberName = vc.getPlayerNameFromId(memberId);
                if (memberName == null) continue;
                this.groupMembers.add(memberName);
            }
        }
        this.buildMemberEntries();
    }

    @Override
    protected void renderContent(int mouseX, int mouseY, float tickDelta) {
        int wheel = Mouse.getDWheel();
        if (wheel != 0) {
            int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
            int contentTop = backgroundY + 24;
            int contentBottom = backgroundY + this.backgroundHeight - 36;
            int contentHeight = contentBottom - contentTop;
            int maxScroll = Math.max(0, this.entries.size() * 24 - contentHeight);
            this.scrollOffset -= (int)Math.signum(wheel) * 16;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > maxScroll) {
                this.scrollOffset = maxScroll;
            }
        }
        this.layoutAndRenderEntries(mouseX, mouseY, tickDelta);
    }

    @Override
    protected String getBackgroundTexture() {
        return "/assets/legacyvoicechat/textures/gui/group.png";
    }

    @Override
    protected String getTitle() {
        return "Group: " + (this.currentGroupName == null || this.currentGroupName.isEmpty() ? "Unknown" : this.currentGroupName);
    }

    @Override
    protected void handleCustomButtonClick(C_2348249 button) {
        if (button.f_5920996 == 1106) {
            Voice.leaveGroup();
            System.out.println("Leaving group: " + this.currentGroupName);
            this.f_7153641.m_6408915((C_3020744)new GroupsScreen());
        }
    }

    private void buildMemberEntries() {
        this.entries.clear();
        ArrayList toKeep = new ArrayList();
        for (Object o : this.f_2213969) {
            if (!(o instanceof C_2348249)) continue;
            C_2348249 b = (C_2348249)o;
            if (b.f_5920996 != 3000 && b.f_5920996 != 3001 && b.f_5920996 != 3002) continue;
            toKeep.add(o);
        }
        this.f_2213969.clear();
        for (Object o : toKeep) {
            this.f_2213969.add(o);
        }
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        for (String memberName : this.groupMembers) {
            this.entries.add(new MemberEntry(memberName));
        }
        int buttonY = backgroundY + this.backgroundHeight - 28;
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        this.f_2213969.add(new C_2348249(1106, backgroundX + 8, buttonY, this.backgroundWidth - 16, 20, "Leave Group"));
    }

    private void layoutAndRenderEntries(int mouseX, int mouseY, float tickDelta) {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        int contentTop = backgroundY + 24;
        int contentBottom = backgroundY + this.backgroundHeight - 36;
        if (this.entries.isEmpty()) {
            String message = "No members in group";
            int messageWidth = this.f_2020658.m_0040387(message);
            int messageX = backgroundX + (this.backgroundWidth - messageWidth) / 2;
            int messageY = backgroundY + this.backgroundHeight / 2;
            this.f_2020658.m_4683674(message, messageX, messageY, 0xAAAAAA);
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean visible;
            MemberEntry e = this.entries.get(i);
            int rowY = contentTop + i * 24 - this.scrollOffset;
            boolean bl = visible = rowY + 20 > contentTop && rowY < contentBottom;
            if (!visible) continue;
            this.f_2020658.m_4683674(e.memberName, backgroundX + 10, rowY + 6, 0xFFFFFF);
        }
    }

    public void updateMemberList(List<String> members) {
        this.groupMembers = new ArrayList<String>(members);
        this.buildMemberEntries();
    }

    public static void updateCurrentMemberList(List<String> members) {
        if (currentInstance != null) {
            currentInstance.updateMemberList(members);
        }
    }

    public void m_8984281() {
        if (currentInstance == this) {
            currentInstance = null;
        }
        super.m_8984281();
    }

    private static class MemberEntry {
        final String memberName;

        MemberEntry(String memberName) {
            this.memberName = memberName;
        }
    }
}

