/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.Voice;
import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.GroupMembersScreen;
import com.moyettes.voice.gui.GroupsScreen;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;

public class JoinGroupScreen
extends BaseVoiceScreen {
    private String passwordText = "";
    private C_2348249 joinButton;
    private C_2348249 backButton;
    private String groupName;

    public JoinGroupScreen(String groupName) {
        this.groupName = groupName;
    }

    @Override
    protected void initContent() {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        int buttonY = backgroundY + this.backgroundHeight - 60;
        int buttonWidth = (this.backgroundWidth - 40) / 2;
        int buttonSpacing = 8;
        this.joinButton = new C_2348249(4001, backgroundX + 16, buttonY, buttonWidth, 20, "Join Group");
        this.backButton = new C_2348249(4002, backgroundX + 16 + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20, "Back");
        System.out.println("JoinGroupScreen: Initializing buttons - Join button at (" + this.joinButton.f_3923091 + ", " + this.joinButton.f_8532347 + ") with ID " + this.joinButton.f_5920996);
        System.out.println("JoinGroupScreen: Back button at (" + this.backButton.f_3923091 + ", " + this.backButton.f_8532347 + ") with ID " + this.backButton.f_5920996);
        this.f_2213969.add(this.joinButton);
        this.f_2213969.add(this.backButton);
    }

    @Override
    protected void renderContent(int mouseX, int mouseY, float tickDelta) {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        this.f_2020658.m_4683674("Join Group: " + this.groupName, backgroundX + 16, backgroundY + 30, 0xFFFFFF);
        this.f_2020658.m_4683674("Enter Password:", backgroundX + 16, backgroundY + 60, 0xFFFFFF);
        String displayPassword = this.passwordText.isEmpty() ? "Enter password..." : this.passwordText;
        this.f_2020658.m_4683674(displayPassword, backgroundX + 16, backgroundY + 75, this.passwordText.isEmpty() ? 0xAAAAAA : 0xFFFF00);
    }

    @Override
    protected String getBackgroundTexture() {
        return "/assets/legacyvoicechat/textures/gui/group.png";
    }

    @Override
    protected String getTitle() {
        return "Join Group";
    }

    @Override
    protected void handleCustomButtonClick(C_2348249 button) {
        System.out.println("JoinGroupScreen: Button clicked with ID: " + button.f_5920996);
        if (button.f_5920996 == 4001) {
            String password = this.passwordText.trim();
            System.out.println("JoinGroupScreen: Attempting to join group '" + this.groupName + "' with password: " + (password.isEmpty() ? "null" : password));
            Voice.joinGroup(this.groupName, password.isEmpty() ? null : password);
            this.f_7153641.m_6408915((C_3020744)new GroupMembersScreen());
        } else if (button.f_5920996 == 4002) {
            System.out.println("JoinGroupScreen: Going back to groups screen");
            this.f_7153641.m_6408915((C_3020744)new GroupsScreen());
        } else {
            System.out.println("JoinGroupScreen: Unknown button ID: " + button.f_5920996);
        }
    }

    public void m_6992336(char character, int keyCode) {
        if (keyCode == 1) {
            this.f_7153641.m_6408915((C_3020744)new GroupsScreen());
            return;
        }
        if (keyCode == 28) {
            String password = this.passwordText.trim();
            Voice.joinGroup(this.groupName, password.isEmpty() ? null : password);
            this.f_7153641.m_6408915((C_3020744)new GroupMembersScreen());
            return;
        }
        if (keyCode == 14) {
            if (!this.passwordText.isEmpty()) {
                this.passwordText = this.passwordText.substring(0, this.passwordText.length() - 1);
            }
            return;
        }
        if (character >= ' ' && character <= '~') {
            if (this.passwordText.length() < 32) {
                this.passwordText = this.passwordText + character;
            }
            return;
        }
        super.m_6992336(character, keyCode);
    }

    public void m_7362766(int mouseX, int mouseY, int button) {
        if (button == 0) {
            int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
            int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
            if (mouseX >= backgroundX + 16 && mouseX <= backgroundX + this.backgroundWidth - 16 && mouseY >= backgroundY + 75 && mouseY <= backgroundY + 90) {
                return;
            }
        }
        super.m_7362766(mouseX, mouseY, button);
    }
}

