/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GroupMemberUpdatePacket
extends UdpPacket {
    private UpdateType updateType;
    private String groupName;
    private Integer playerNetworkId;
    private String playerName;
    private List<String> groupMembers;

    public GroupMemberUpdatePacket() {
        super(UdpPacket.PacketType.GROUP_MEMBER_UPDATE);
        this.groupMembers = new ArrayList<String>();
    }

    public GroupMemberUpdatePacket(UpdateType updateType, String groupName, Integer playerNetworkId, String playerName, List<String> groupMembers) {
        super(UdpPacket.PacketType.GROUP_MEMBER_UPDATE);
        this.updateType = updateType;
        this.groupName = groupName;
        this.playerNetworkId = playerNetworkId;
        this.playerName = playerName;
        this.groupMembers = groupMembers != null ? groupMembers : new ArrayList();
    }

    @Override
    protected void writeData(DataOutputStream dos) throws IOException {
        dos.writeByte(this.updateType.getId());
        dos.writeUTF(this.groupName != null ? this.groupName : "");
        dos.writeInt(this.playerNetworkId != null ? this.playerNetworkId : -1);
        dos.writeUTF(this.playerName != null ? this.playerName : "");
        dos.writeInt(this.groupMembers.size());
        for (String member : this.groupMembers) {
            dos.writeUTF(member);
        }
    }

    public static GroupMemberUpdatePacket read(DataInputStream dis) throws IOException {
        GroupMemberUpdatePacket packet = new GroupMemberUpdatePacket();
        packet.updateType = UpdateType.fromId(dis.readByte());
        packet.groupName = dis.readUTF();
        int playerId = dis.readInt();
        packet.playerNetworkId = playerId == -1 ? null : Integer.valueOf(playerId);
        packet.playerName = dis.readUTF();
        int memberCount = dis.readInt();
        for (int i = 0; i < memberCount; ++i) {
            packet.groupMembers.add(dis.readUTF());
        }
        return packet;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Integer getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public List<String> getGroupMembers() {
        return this.groupMembers;
    }

    public static enum UpdateType {
        MEMBER_JOINED(0),
        MEMBER_LEFT(1),
        GROUP_CREATED(2),
        GROUP_DELETED(3);

        private final int id;

        private UpdateType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static UpdateType fromId(int id) {
            for (UpdateType type : UpdateType.values()) {
                if (type.id != id) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown update type: " + id);
        }
    }
}

