/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleqol;

import com.github.ob_yekt.simpleqol.ConfigManager;
import java.util.Iterator;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1928;
import net.minecraft.class_2596;
import net.minecraft.class_2761;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeController
implements ServerTickEvents.StartTick {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"simpleqol");
    private static boolean initialized = false;
    private static int stabilizationTicks = 20;
    private static long tickCounter;
    private static long visualTime;
    private static long dayTicks;
    private static long nightTicks;

    public static void init(MinecraftServer server) {
        ConfigManager.load();
        dayTicks = ConfigManager.getDayTicks();
        nightTicks = ConfigManager.getNightTicks();
        tickCounter = ConfigManager.getTickCounter();
        ServerTickEvents.START_SERVER_TICK.register((Object)new TimeController());
        LOGGER.info("TimeController initialized with dayTicks: {}, nightTicks: {}, tickCounter: {}", new Object[]{dayTicks, nightTicks, tickCounter});
    }

    private static void updateVisualTime(MinecraftServer server) {
        long totalCycle = dayTicks + nightTicks;
        long tickOfCycle = tickCounter % totalCycle;
        if (tickOfCycle < dayTicks) {
            visualTime = tickOfCycle * 12542L / dayTicks;
        } else {
            long nightElapsed = tickOfCycle - dayTicks;
            visualTime = 12542L + nightElapsed * 11457L / nightTicks;
        }
        for (class_3218 world : server.method_3738()) {
            world.method_29199(visualTime);
            for (class_3222 player : world.method_18456()) {
                player.field_13987.method_14364((class_2596)new class_2761(world.method_8510(), visualTime, false));
            }
        }
        LOGGER.debug("Updated visualTime: {}, tickCounter: {}", (Object)visualTime, (Object)tickCounter);
    }

    public void onStartTick(MinecraftServer server) {
        class_3218 world;
        long worldTime;
        if (!initialized && server.method_3738().iterator().hasNext()) {
            class_3218 world2 = (class_3218)server.method_3738().iterator().next();
            long worldTime2 = world2.method_8532();
            tickCounter = Math.max(0L, worldTime2);
            LOGGER.info("First tick sync: tickCounter: {} for worldTime: {}", (Object)tickCounter, (Object)worldTime2);
            initialized = true;
        }
        if (stabilizationTicks > 0) {
            LOGGER.debug("Stabilization tick: {}, worldTime: {}", (Object)(--stabilizationTicks), (Object)((class_3218)server.method_3738().iterator().next()).method_8532());
            return;
        }
        Iterator iterator = server.method_3738().iterator();
        if (iterator.hasNext() && Math.abs((worldTime = (world = (class_3218)iterator.next()).method_8532()) - visualTime) > 5L) {
            TimeController.syncTickCounterToWorldTime(worldTime);
            LOGGER.info("Detected time change - synced tickCounter: {} for worldTime: {}", (Object)tickCounter, (Object)worldTime);
            ConfigManager.setTickCounter(tickCounter);
            ConfigManager.save();
        }
        if (++tickCounter == 1L) {
            for (class_3218 world3 : server.method_3738()) {
                ((class_1928.class_4310)world3.method_64395().method_20746(class_1928.field_19396)).method_20758(false, server);
            }
        }
        TimeController.updateVisualTime(server);
    }

    private static void syncTickCounterToWorldTime(long worldTime) {
        if (worldTime < 12542L) {
            tickCounter = worldTime * dayTicks / 12542L;
        } else {
            long nightTime = worldTime - 12542L;
            tickCounter = dayTicks + nightTime * nightTicks / 11457L;
        }
        tickCounter = Math.max(0L, tickCounter);
    }

    public static void resetTime() {
        tickCounter = 0L;
        ConfigManager.setTickCounter(0L);
        ConfigManager.save();
        LOGGER.info("Reset tickCounter to 0");
    }

    public static long getDayTicks() {
        return dayTicks;
    }

    public static long getNightTicks() {
        return nightTicks;
    }

    public static void setDayTicks(long newDayTicks, MinecraftServer server) {
        dayTicks = Math.max(1L, newDayTicks);
        if (server.method_3738().iterator().hasNext()) {
            class_3218 world = (class_3218)server.method_3738().iterator().next();
            long worldTime = world.method_8532();
            TimeController.syncTickCounterToWorldTime(worldTime);
            LOGGER.info("Set dayTicks: {}, recalculated tickCounter: {} for worldTime: {}", new Object[]{dayTicks, tickCounter, worldTime});
        }
        ConfigManager.setDayTicks(dayTicks);
        ConfigManager.setTickCounter(tickCounter);
        ConfigManager.save();
        TimeController.updateVisualTime(server);
    }

    public static void setNightTicks(long newNightTicks, MinecraftServer server) {
        nightTicks = Math.max(1L, newNightTicks);
        if (server.method_3738().iterator().hasNext()) {
            class_3218 world = (class_3218)server.method_3738().iterator().next();
            long worldTime = world.method_8532();
            TimeController.syncTickCounterToWorldTime(worldTime);
            LOGGER.info("Set nightTicks: {}, recalculated tickCounter: {} for worldTime: {}", new Object[]{nightTicks, tickCounter, worldTime});
        }
        ConfigManager.setNightTicks(nightTicks);
        ConfigManager.setTickCounter(tickCounter);
        ConfigManager.save();
        TimeController.updateVisualTime(server);
    }

    public static void onServerStop() {
        ConfigManager.setTickCounter(tickCounter);
        ConfigManager.save();
        LOGGER.info("Saved final tickCounter state: {}", (Object)tickCounter);
    }
}

