/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleqol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getGameDir().resolve("config").resolve("simpleqol_config.json");
    private static Config config = new Config();

    public static void populateDefaults() {
        ConfigManager.config.biomeReplacements.put("minecraft:stony_shore", "minecraft:beach");
        ConfigManager.config.biomeReplacements.put("minecraft:windswept_gravelly_hills", "minecraft:windswept_hills");
    }

    public static void load() {
        boolean isFirstGeneration;
        boolean bl = isFirstGeneration = !Files.exists(CONFIG_PATH, new LinkOption[0]);
        if (!isFirstGeneration) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                Config loadedConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (loadedConfig != null) {
                    config = loadedConfig;
                    if (ConfigManager.config.tickCounter < 0L) {
                        ConfigManager.config.tickCounter = 0L;
                    }
                    if (ConfigManager.config.overworldPhantomSpawnWeight < 0) {
                        ConfigManager.config.overworldPhantomSpawnWeight = 0;
                    }
                    if (ConfigManager.config.endPhantomSpawnWeight < 0) {
                        ConfigManager.config.endPhantomSpawnWeight = 0;
                    }
                    if (ConfigManager.config.overworldPhantomMinPackSize < 1) {
                        ConfigManager.config.overworldPhantomMinPackSize = 1;
                    }
                    if (ConfigManager.config.overworldPhantomMaxPackSize < ConfigManager.config.overworldPhantomMinPackSize) {
                        ConfigManager.config.overworldPhantomMaxPackSize = ConfigManager.config.overworldPhantomMinPackSize;
                    }
                    if (ConfigManager.config.endPhantomMinPackSize < 1) {
                        ConfigManager.config.endPhantomMinPackSize = 1;
                    }
                    if (ConfigManager.config.endPhantomMaxPackSize < ConfigManager.config.endPhantomMinPackSize) {
                        ConfigManager.config.endPhantomMaxPackSize = ConfigManager.config.endPhantomMinPackSize;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (isFirstGeneration) {
            ConfigManager.populateDefaults();
        }
        ConfigManager.save();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static long getDayTicks() {
        return ConfigManager.config.dayTicks;
    }

    public static void setDayTicks(long ticks) {
        ConfigManager.config.dayTicks = Math.max(1L, ticks);
    }

    public static long getNightTicks() {
        return ConfigManager.config.nightTicks;
    }

    public static void setNightTicks(long ticks) {
        ConfigManager.config.nightTicks = Math.max(1L, ticks);
    }

    public static long getTickCounter() {
        return ConfigManager.config.tickCounter;
    }

    public static void setTickCounter(long ticks) {
        ConfigManager.config.tickCounter = Math.max(0L, ticks);
    }

    public static Map<String, String> getBiomeReplacements() {
        return ConfigManager.config.biomeReplacements;
    }

    public static boolean isEndermanGriefingAllowed() {
        return ConfigManager.config.endermanGriefing;
    }

    public static boolean isSweetBerryBushDamageAllowed() {
        return ConfigManager.config.sweetberrybushDamage;
    }

    public static int getOverworldPhantomSpawnWeight() {
        return ConfigManager.config.overworldPhantomSpawnWeight;
    }

    public static int getEndPhantomSpawnWeight() {
        return ConfigManager.config.endPhantomSpawnWeight;
    }

    public static int getOverworldPhantomMinPackSize() {
        return Math.max(1, ConfigManager.config.overworldPhantomMinPackSize);
    }

    public static int getOverworldPhantomMaxPackSize() {
        return Math.max(ConfigManager.getOverworldPhantomMinPackSize(), ConfigManager.config.overworldPhantomMaxPackSize);
    }

    public static int getEndPhantomMinPackSize() {
        return Math.max(1, ConfigManager.config.endPhantomMinPackSize);
    }

    public static int getEndPhantomMaxPackSize() {
        return Math.max(ConfigManager.getEndPhantomMinPackSize(), ConfigManager.config.endPhantomMaxPackSize);
    }

    public static boolean isDoInsomniaEnabled() {
        return ConfigManager.config.doInsomnia;
    }

    public static int getTorchflowerBrightness() {
        return ConfigManager.config.torchflowerBrightness;
    }

    public static int getTorchflowerStage0Brightness() {
        return ConfigManager.config.torchflowerStage0Brightness;
    }

    public static int getTorchflowerStage1Brightness() {
        return ConfigManager.config.torchflowerStage1Brightness;
    }

    public static int getTorchflowerStage2Brightness() {
        return ConfigManager.config.torchflowerStage2Brightness;
    }

    public static int getPottedTorchflowerBrightness() {
        return ConfigManager.config.pottedTorchflowerBrightness;
    }

    public static int getOpenEyeblossomBrightness() {
        return ConfigManager.config.openEyeblossomBrightness;
    }

    public static int getClosedEyeblossomBrightness() {
        return ConfigManager.config.closedEyeblossomBrightness;
    }

    public static int getPottedOpenEyeblossomBrightness() {
        return ConfigManager.config.pottedOpenEyeblossomBrightness;
    }

    public static int getPottedClosedEyeblossomBrightness() {
        return ConfigManager.config.pottedClosedEyeblossomBrightness;
    }

    public static int getPitcherPlantBrightness() {
        return ConfigManager.config.pitcherPlantBrightness;
    }

    public static int getPitcherCropStage0Brightness() {
        return ConfigManager.config.pitcherCropStage0Brightness;
    }

    public static int getPitcherCropStage1Brightness() {
        return ConfigManager.config.pitcherCropStage1Brightness;
    }

    public static int getPitcherCropStage2Brightness() {
        return ConfigManager.config.pitcherCropStage2Brightness;
    }

    public static int getPitcherCropStage3Brightness() {
        return ConfigManager.config.pitcherCropStage3Brightness;
    }

    public static int getPitcherCropStage4Brightness() {
        return ConfigManager.config.pitcherCropStage4Brightness;
    }

    public static class Config {
        public Map<String, String> biomeReplacements = new HashMap<String, String>();
        public long dayTicks = 24000L;
        public long nightTicks = 12000L;
        public long tickCounter = 0L;
        public boolean endermanGriefing = false;
        public boolean sweetberrybushDamage = false;
        public int overworldPhantomSpawnWeight = 2;
        public int endPhantomSpawnWeight = 1;
        public int overworldPhantomMinPackSize = 1;
        public int overworldPhantomMaxPackSize = 2;
        public int endPhantomMinPackSize = 1;
        public int endPhantomMaxPackSize = 1;
        public boolean doInsomnia = false;
        public int torchflowerBrightness = 14;
        public int pottedTorchflowerBrightness = 14;
        public int torchflowerStage0Brightness = 1;
        public int torchflowerStage1Brightness = 7;
        public int torchflowerStage2Brightness = 14;
        public int openEyeblossomBrightness = 4;
        public int closedEyeblossomBrightness = 2;
        public int pottedOpenEyeblossomBrightness = 4;
        public int pottedClosedEyeblossomBrightness = 2;
        public int pitcherPlantBrightness = 9;
        public int pitcherCropStage0Brightness = 1;
        public int pitcherCropStage1Brightness = 2;
        public int pitcherCropStage2Brightness = 3;
        public int pitcherCropStage3Brightness = 6;
        public int pitcherCropStage4Brightness = 9;
    }
}

