/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleqol;

import com.github.ob_yekt.simpleqol.ConfigManager;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1928;
import net.minecraft.class_1972;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"simpleqol-phantoms");

    public static void initialize() {
        LOGGER.info("Initializing phantom spawn modifications...");
        int overworldWeight = ConfigManager.getOverworldPhantomSpawnWeight();
        int endWeight = ConfigManager.getEndPhantomSpawnWeight();
        if (overworldWeight > 0) {
            PhantomManager.addOverworldPhantomSpawns(overworldWeight);
            LOGGER.info("Overworld phantom spawning: ENABLED (weight: {})", (Object)overworldWeight);
        } else {
            LOGGER.info("Overworld phantom spawning: DISABLED");
        }
        if (endWeight > 0) {
            PhantomManager.addEndPhantomSpawns(endWeight);
            LOGGER.info("End phantom spawning: ENABLED (weight: {})", (Object)endWeight);
        } else {
            LOGGER.info("End phantom spawning: DISABLED");
        }
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            boolean doInsomnia = ConfigManager.isDoInsomniaEnabled();
            for (class_3218 world : server.method_3738()) {
                ((class_1928.class_4310)world.method_64395().method_20746(class_1928.field_20637)).method_20758(doInsomnia, server);
            }
            LOGGER.info("Gamerule doInsomnia set to {}", (Object)doInsomnia);
        });
        LOGGER.info("Phantom spawn modifications applied successfully");
    }

    private static void addOverworldPhantomSpawns(int weight) {
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.foundInOverworld(), (class_1311)class_1311.field_6302, (class_1299)class_1299.field_6078, (int)weight, (int)ConfigManager.getOverworldPhantomMinPackSize(), (int)ConfigManager.getOverworldPhantomMaxPackSize());
    }

    private static void addEndPhantomSpawns(int weight) {
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9442, class_1972.field_9447}), (class_1311)class_1311.field_6302, (class_1299)class_1299.field_6078, (int)weight, (int)ConfigManager.getEndPhantomMinPackSize(), (int)ConfigManager.getEndPhantomMaxPackSize());
    }
}

