/*
 * Decompiled with CFR 0.152.
 */
package net.smilenotalive.rpghealthoverhaul.configuration;

import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigConfiguration {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Boolean> SLEEPING_HEALTH_REGENERATION;
    public static final ModConfigSpec.ConfigValue<Boolean> SLEEPING_HEALTH_BUFF;
    public static final ModConfigSpec.ConfigValue<Double> SLEEPING_HEALTH_BUFF_LEVEL;
    public static final ModConfigSpec.ConfigValue<Boolean> SLEEPING_HUNGER_DEGENERATION;
    public static final ModConfigSpec.ConfigValue<Boolean> LIFE_CRYSTAL_GENERATION;
    public static final ModConfigSpec.ConfigValue<Double> LIFE_CRYSTAL_MAX_HEALTH;
    public static final ModConfigSpec.ConfigValue<Double> INITIAL_MAX_HEALTH;

    static {
        BUILDER.push("Sleeping Health");
        SLEEPING_HEALTH_REGENERATION = BUILDER.comment("Enable health regeneration after waking up (Default is true)").define("sleeping_health_regeneration", true);
        SLEEPING_HEALTH_BUFF = BUILDER.comment("Enable absorption effect for a random short time after waking up (Default is true) (This requires 'Sleeping Health Regeneration' to be true)").define("sleeping_health_buff", true);
        SLEEPING_HEALTH_BUFF_LEVEL = BUILDER.comment("Level of absorption effect (Default is 1) (This requires 'Sleeping Health Buff' to be true)").define("sleeping_health_buff_level", (Object)1.0);
        BUILDER.pop();
        BUILDER.push("Sleeping Hunger");
        SLEEPING_HUNGER_DEGENERATION = BUILDER.comment("Enable hunger degeneration after waking up (Default is true)").define("sleeping_hunger_degeneration", true);
        BUILDER.pop();
        BUILDER.push("Life Crystal");
        LIFE_CRYSTAL_GENERATION = BUILDER.comment("Enable Life Crystal generation (Default is true)").define("life_crystal_generation", true);
        LIFE_CRYSTAL_MAX_HEALTH = BUILDER.comment("Max health of the player when using Life Crystals (Default is 40 = 20 hearts)").define("life_crystal_max_health", (Object)40.0);
        BUILDER.pop();
        BUILDER.push("Others");
        INITIAL_MAX_HEALTH = BUILDER.comment("Max health of the player when joining the world for the first time (Default is 20 = 10 hearts)").define("initial_max_health", (Object)20.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

