/*
 * Decompiled with CFR 0.152.
 */
package com.hariharnautiyal.velocity.userencryptVelocity;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.hariharnautiyal.velocity.userencryptVelocity.libs.kfaker.kfaker.Faker;
import com.hariharnautiyal.velocity.userencryptVelocity.libs.kotlin.Metadata;
import com.hariharnautiyal.velocity.userencryptVelocity.libs.kotlin.Unit;
import com.hariharnautiyal.velocity.userencryptVelocity.libs.kotlin.collections.CollectionsKt;
import com.hariharnautiyal.velocity.userencryptVelocity.libs.kotlin.io.CloseableKt;
import com.hariharnautiyal.velocity.userencryptVelocity.libs.kotlin.jvm.internal.Intrinsics;
import com.hariharnautiyal.velocity.userencryptVelocity.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hariharnautiyal.velocity.userencryptVelocity.libs.kotlin.text.Charsets;
import com.hariharnautiyal.velocity.userencryptVelocity.libs.kotlin.text.StringsKt;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.util.GameProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Plugin(id="userencrypt-velocity", name="userencrypt-velocity", version="1.0-SNAPSHOT", description="UserEncrypt minecraft velocity plugin to prevent from username stealing in offline mode servers.", url="https://harihar.site/projects/userencrypt", authors={"Harihar Nautiyal"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001aH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/hariharnautiyal/velocity/userencryptVelocity/UserencryptVelocity;", "", "proxyServer", "Lcom/velocitypowered/api/proxy/ProxyServer;", "logger", "Lorg/slf4j/Logger;", "dataFolder", "Ljava/nio/file/Path;", "<init>", "(Lcom/velocitypowered/api/proxy/ProxyServer;Lorg/slf4j/Logger;Ljava/nio/file/Path;)V", "playerAliases", "", "", "playersFile", "gson", "Lcom/google/gson/Gson;", "faker", "Lcom/hariharnautiyal/velocity/userencryptVelocity/libs/kfaker/kfaker/Faker;", "onProxyInitialization", "", "event", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "loadData", "saveData", "generateUniqueUsername", "onGameProfileRequest", "Lcom/velocitypowered/api/event/player/GameProfileRequestEvent;", "userencrypt-velocity"})
@SourceDebugExtension(value={"SMAP\nUserencryptVelocity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserencryptVelocity.kt\ncom/hariharnautiyal/velocity/userencryptVelocity/UserencryptVelocity\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,107:1\n381#2,7:108\n*S KotlinDebug\n*F\n+ 1 UserencryptVelocity.kt\ncom/hariharnautiyal/velocity/userencryptVelocity/UserencryptVelocity\n*L\n96#1:108,7\n*E\n"})
public final class UserencryptVelocity {
    @NotNull
    private final ProxyServer proxyServer;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Path dataFolder;
    @NotNull
    private final Map<String, String> playerAliases;
    private Path playersFile;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Faker faker;

    @Inject
    public UserencryptVelocity(@NotNull ProxyServer proxyServer, @NotNull Logger logger, @DataDirectory @NotNull Path dataFolder) {
        Intrinsics.checkNotNullParameter(proxyServer, "proxyServer");
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        this.proxyServer = proxyServer;
        this.logger = logger;
        this.dataFolder = dataFolder;
        this.playerAliases = new ConcurrentHashMap();
        this.gson = new Gson();
        this.faker = new Faker(null, 1, null);
    }

    @Subscribe
    public final void onProxyInitialization(@NotNull ProxyInitializeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(this.dataFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue(Files.createDirectories(this.dataFolder, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(...)");
            }
            this.playersFile = this.dataFolder.resolve("players.json");
            this.loadData();
            this.logger.info("UserEncrypt 1.0-SNAPSHOT initialized successfully using JSON storage.");
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize UserEncrypt. The plugin will be disabled.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadData() {
        Object object;
        Object object2;
        Path path = this.playersFile;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException("playersFile");
            path = null;
        }
        if (Files.exists((Path)(object2 = path), Arrays.copyOf(object = new LinkOption[0], ((LinkOption[])object).length))) {
            try {
                Path path2 = this.playersFile;
                if (path2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("playersFile");
                    path2 = null;
                }
                object2 = Files.newBufferedReader(path2);
                object = null;
                try {
                    BufferedReader reader = (BufferedReader)object2;
                    boolean bl = false;
                    Type type2 = new TypeToken<ConcurrentHashMap<String, String>>(){}.getType();
                    Object object3 = this.gson.fromJson((Reader)reader, type2);
                    Intrinsics.checkNotNullExpressionValue(object3, "fromJson(...)");
                    this.playerAliases.putAll((Map)object3);
                    this.logger.info("Loaded " + this.playerAliases.size() + " player entries from players.json");
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                }
            }
            catch (Exception e) {
                this.logger.error("Could not read or parse players.json. A new file will be created.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveData() {
        try {
            Path path = this.playersFile;
            if (path == null) {
                Intrinsics.throwUninitializedPropertyAccessException("playersFile");
                path = null;
            }
            Closeable closeable = Files.newBufferedWriter(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                this.gson.toJson(this.playerAliases, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to save data to players.json!", (Throwable)e);
        }
    }

    private final String generateUniqueUsername() {
        String newUsername = null;
        while (this.playerAliases.containsValue(newUsername = StringsKt.replace$default(this.faker.getGame().title(), " ", "", false, 4, null) + this.faker.getRandom().nextInt(1000, 9999))) {
        }
        return newUsername;
    }

    @Subscribe
    public final void onGameProfileRequest(@NotNull GameProfileRequestEvent event) {
        String string2;
        Intrinsics.checkNotNullParameter(event, "event");
        String originalName = event.getUsername();
        this.logger.info(originalName);
        Map<String, String> $this$getOrPut$iv = this.playerAliases;
        boolean $i$f$getOrPut = false;
        String value$iv = $this$getOrPut$iv.get(originalName);
        if (value$iv == null) {
            boolean bl = false;
            String newAlias = this.generateUniqueUsername();
            this.saveData();
            String answer$iv = newAlias;
            $this$getOrPut$iv.put(originalName, answer$iv);
            string2 = answer$iv;
        } else {
            string2 = value$iv;
        }
        String alias = string2;
        byte[] byArray = ("OfflinePlayer:" + alias).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        UUID offlineUuid = UUID.nameUUIDFromBytes(byArray);
        GameProfile newProfile = new GameProfile(offlineUuid, alias, CollectionsKt.emptyList());
        event.setGameProfile(newProfile);
    }
}

