/*
 * Decompiled with CFR 0.152.
 */
package faker.com.ibm.icu.impl.coll;

import faker.com.ibm.icu.impl.ICUResourceBundle;
import faker.com.ibm.icu.impl.coll.CollationDataReader;
import faker.com.ibm.icu.impl.coll.CollationRoot;
import faker.com.ibm.icu.impl.coll.CollationTailoring;
import faker.com.ibm.icu.util.ICUUncheckedIOException;
import faker.com.ibm.icu.util.Output;
import faker.com.ibm.icu.util.ULocale;
import faker.com.ibm.icu.util.UResourceBundle;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.MissingResourceException;

public final class CollationLoader {
    private static volatile String rootRules = null;

    private CollationLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRootRules() {
        if (rootRules != null) {
            return;
        }
        Class<CollationLoader> clazz = CollationLoader.class;
        synchronized (CollationLoader.class) {
            if (rootRules == null) {
                UResourceBundle rootBundle = UResourceBundle.getBundleInstance("faker/com/ibm/icu/impl/data/icudt71b/coll", ULocale.ROOT);
                rootRules = rootBundle.getString("UCARules");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String getRootRules() {
        CollationLoader.loadRootRules();
        return rootRules;
    }

    static String loadRules(ULocale locale, String collationType) {
        UResourceBundle bundle = UResourceBundle.getBundleInstance("faker/com/ibm/icu/impl/data/icudt71b/coll", locale);
        ICUResourceBundle data = ((ICUResourceBundle)bundle).getWithFallback("collations/" + ASCII.toLowerCase(collationType));
        String rules = data.getString("Sequence");
        return rules;
    }

    private static final UResourceBundle findWithFallback(UResourceBundle table, String entryName) {
        return ((ICUResourceBundle)table).findWithFallback(entryName);
    }

    public static CollationTailoring loadTailoring(ULocale locale, Output<ULocale> outValidLocale) {
        UResourceBundle actualBundle;
        UResourceBundle data;
        UResourceBundle collations;
        CollationTailoring root = CollationRoot.getRoot();
        String localeName = locale.getName();
        if (localeName.length() == 0 || localeName.equals("root")) {
            outValidLocale.value = ULocale.ROOT;
            return root;
        }
        ICUResourceBundle bundle = null;
        try {
            bundle = ICUResourceBundle.getBundleInstance("faker/com/ibm/icu/impl/data/icudt71b/coll", locale, ICUResourceBundle.OpenType.LOCALE_ROOT);
        }
        catch (MissingResourceException e) {
            outValidLocale.value = ULocale.ROOT;
            return root;
        }
        ULocale validLocale = ((UResourceBundle)bundle).getULocale();
        String validLocaleName = validLocale.getName();
        if (validLocaleName.length() == 0 || validLocaleName.equals("root")) {
            validLocale = ULocale.ROOT;
        }
        outValidLocale.value = validLocale;
        try {
            collations = bundle.get("collations");
            if (collations == null) {
                return root;
            }
        }
        catch (MissingResourceException ignored) {
            return root;
        }
        String type2 = locale.getKeywordValue("collation");
        String defaultType = "standard";
        String defT = ((ICUResourceBundle)collations).findStringWithFallback("default");
        if (defT != null) {
            defaultType = defT;
        }
        if ((data = CollationLoader.findWithFallback(collations, type2 = type2 == null || type2.equals("default") ? defaultType : ASCII.toLowerCase(type2))) == null && type2.length() > 6 && type2.startsWith("search")) {
            type2 = "search";
            data = CollationLoader.findWithFallback(collations, type2);
        }
        if (data == null && !type2.equals(defaultType)) {
            type2 = defaultType;
            data = CollationLoader.findWithFallback(collations, type2);
        }
        if (data == null && !type2.equals("standard")) {
            type2 = "standard";
            data = CollationLoader.findWithFallback(collations, type2);
        }
        if (data == null) {
            return root;
        }
        ULocale actualLocale = data.getULocale();
        String actualLocaleName = actualLocale.getName();
        if (actualLocaleName.length() == 0 || actualLocaleName.equals("root")) {
            actualLocale = ULocale.ROOT;
            if (type2.equals("standard")) {
                return root;
            }
        }
        CollationTailoring t = new CollationTailoring(root.settings);
        t.actualLocale = actualLocale;
        UResourceBundle binary = data.get("%%CollationBin");
        ByteBuffer inBytes = binary.getBinary();
        try {
            CollationDataReader.read(root, inBytes, t);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Failed to load collation tailoring data for locale:" + actualLocale + " type:" + type2, e);
        }
        try {
            t.setRulesResource(data.get("Sequence"));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (!type2.equals(defaultType)) {
            outValidLocale.value = validLocale.setKeywordValue("collation", type2);
        }
        if (!actualLocale.equals(validLocale) && (defT = ((ICUResourceBundle)(actualBundle = UResourceBundle.getBundleInstance("faker/com/ibm/icu/impl/data/icudt71b/coll", actualLocale))).findStringWithFallback("collations/default")) != null) {
            defaultType = defT;
        }
        if (!type2.equals(defaultType)) {
            t.actualLocale = t.actualLocale.setKeywordValue("collation", type2);
        }
        return t;
    }

    private static final class ASCII {
        private ASCII() {
        }

        static String toLowerCase(String s) {
            for (int i2 = 0; i2 < s.length(); ++i2) {
                char c = s.charAt(i2);
                if ('A' > c || c > 'Z') continue;
                StringBuilder sb = new StringBuilder(s.length());
                sb.append(s, 0, i2).append((char)(c + 32));
                while (++i2 < s.length()) {
                    c = s.charAt(i2);
                    if ('A' <= c && c <= 'Z') {
                        c = (char)(c + 32);
                    }
                    sb.append(c);
                }
                return sb.toString();
            }
            return s;
        }
    }
}

