/*
 * Decompiled with CFR 0.152.
 */
package faker.com.ibm.icu.impl.number;

import faker.com.ibm.icu.text.DecimalFormatSymbols;
import faker.com.ibm.icu.util.Currency;
import faker.com.ibm.icu.util.ULocale;

public class CustomSymbolCurrency
extends Currency {
    private static final long serialVersionUID = 2497493016770137670L;
    private String symbol1;
    private String symbol2;

    public static Currency resolve(Currency currency2, ULocale locale, DecimalFormatSymbols symbols) {
        if (currency2 == null) {
            currency2 = symbols.getCurrency();
        }
        if (currency2 == null) {
            return Currency.getInstance("XXX");
        }
        if (!currency2.equals(symbols.getCurrency())) {
            return currency2;
        }
        String currency1Sym = symbols.getCurrencySymbol();
        String currency2Sym = symbols.getInternationalCurrencySymbol();
        String currency1 = currency2.getName(symbols.getULocale(), 0, null);
        String currency22 = currency2.getCurrencyCode();
        if (!currency1.equals(currency1Sym) || !currency22.equals(currency2Sym)) {
            return new CustomSymbolCurrency(currency22, currency1Sym, currency2Sym);
        }
        return currency2;
    }

    public CustomSymbolCurrency(String isoCode, String currency1Sym, String currency2Sym) {
        super(isoCode);
        this.symbol1 = currency1Sym;
        this.symbol2 = currency2Sym;
    }

    @Override
    public String getName(ULocale locale, int nameStyle, boolean[] isChoiceFormat) {
        if (nameStyle == 0) {
            if (isChoiceFormat != null) {
                isChoiceFormat[0] = false;
            }
            return this.symbol1;
        }
        return super.getName(locale, nameStyle, isChoiceFormat);
    }

    @Override
    public String getName(ULocale locale, int nameStyle, String pluralCount, boolean[] isChoiceFormat) {
        return super.getName(locale, nameStyle, pluralCount, isChoiceFormat);
    }

    @Override
    public String getCurrencyCode() {
        return this.symbol2;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.symbol1.hashCode() ^ this.symbol2.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && ((CustomSymbolCurrency)other).symbol1.equals(this.symbol1) && ((CustomSymbolCurrency)other).symbol2.equals(this.symbol2);
    }
}

