/*
 * Decompiled with CFR 0.152.
 */
package faker.com.ibm.icu.impl.number.parse;

import faker.com.ibm.icu.impl.StringSegment;
import faker.com.ibm.icu.impl.number.parse.ParsedNumber;
import faker.com.ibm.icu.impl.number.parse.SymbolMatcher;
import faker.com.ibm.icu.text.DecimalFormatSymbols;
import faker.com.ibm.icu.text.UnicodeSet;

public class NanMatcher
extends SymbolMatcher {
    private static final NanMatcher DEFAULT = new NanMatcher("NaN");

    public static NanMatcher getInstance(DecimalFormatSymbols symbols, int parseFlags) {
        String symbolString = symbols.getNaN();
        if (NanMatcher.DEFAULT.string.equals(symbolString)) {
            return DEFAULT;
        }
        return new NanMatcher(symbolString);
    }

    private NanMatcher(String symbolString) {
        super(symbolString, UnicodeSet.EMPTY);
    }

    @Override
    protected boolean isDisabled(ParsedNumber result2) {
        return result2.seenNumber();
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result2) {
        result2.flags |= 0x40;
        result2.setCharsConsumed(segment);
    }

    public String toString() {
        return "<NanMatcher>";
    }
}

