/*
 * Decompiled with CFR 0.152.
 */
package faker.com.ibm.icu.impl.number.parse;

import faker.com.ibm.icu.impl.StaticUnicodeSets;
import faker.com.ibm.icu.impl.StringSegment;
import faker.com.ibm.icu.impl.number.parse.ParsedNumber;
import faker.com.ibm.icu.impl.number.parse.SymbolMatcher;
import faker.com.ibm.icu.text.DecimalFormatSymbols;

public class PercentMatcher
extends SymbolMatcher {
    private static final PercentMatcher DEFAULT = new PercentMatcher();

    public static PercentMatcher getInstance(DecimalFormatSymbols symbols) {
        String symbolString = symbols.getPercentString();
        if (PercentMatcher.DEFAULT.uniSet.contains(symbolString)) {
            return DEFAULT;
        }
        return new PercentMatcher(symbolString);
    }

    private PercentMatcher(String symbolString) {
        super(symbolString, PercentMatcher.DEFAULT.uniSet);
    }

    private PercentMatcher() {
        super(StaticUnicodeSets.Key.PERCENT_SIGN);
    }

    @Override
    protected boolean isDisabled(ParsedNumber result2) {
        return 0 != (result2.flags & 2);
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result2) {
        result2.flags |= 2;
        result2.setCharsConsumed(segment);
    }

    public String toString() {
        return "<PercentMatcher>";
    }
}

