/*
 * Decompiled with CFR 0.152.
 */
package com.hariharnautiyal.velocity.userencrypt;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.util.GameProfile;
import io.github.serpro69.kfaker.Faker;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.geysermc.floodgate.api.FloodgateApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Plugin(id="userencrypt", name="userencrypt", version="1.0.2", description="UserEncrypt minecraft velocity plugin to prevent from username stealing in offline mode servers.", url="https://harihar.site/projects/userencrypt", authors={"Harihar Nautiyal"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001eH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/hariharnautiyal/velocity/userencrypt/Main;", "", "proxyServer", "Lcom/velocitypowered/api/proxy/ProxyServer;", "logger", "Lorg/slf4j/Logger;", "dataFolder", "Ljava/nio/file/Path;", "<init>", "(Lcom/velocitypowered/api/proxy/ProxyServer;Lorg/slf4j/Logger;Ljava/nio/file/Path;)V", "connection", "Ljava/sql/Connection;", "faker", "Lio/github/serpro69/kfaker/Faker;", "floodgateLink", "Lcom/hariharnautiyal/velocity/userencrypt/Main$FloodgateLink;", "onProxyInitialization", "", "event", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "createTable", "getAlias", "", "originalName", "saveAlias", "alias", "aliasExists", "", "generateUniqueUsername", "onGameProfileRequest", "Lcom/velocitypowered/api/event/player/GameProfileRequestEvent;", "FloodgateLink", "userencrypt"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\ncom/hariharnautiyal/velocity/userencrypt/Main\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public final class Main {
    @NotNull
    private final ProxyServer proxyServer;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Path dataFolder;
    private Connection connection;
    @NotNull
    private final Faker faker;
    @Nullable
    private FloodgateLink floodgateLink;

    @Inject
    public Main(@NotNull ProxyServer proxyServer, @NotNull Logger logger, @DataDirectory @NotNull Path dataFolder) {
        Intrinsics.checkNotNullParameter(proxyServer, "proxyServer");
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        this.proxyServer = proxyServer;
        this.logger = logger;
        this.dataFolder = dataFolder;
        this.faker = new Faker(null, 1, null);
    }

    @Subscribe
    public final void onProxyInitialization(@NotNull ProxyInitializeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.proxyServer.getPluginManager().isLoaded("floodgate")) {
            try {
                this.floodgateLink = new FloodgateLink();
                this.logger.info("Successfully hooked into Floodgate API. Bedrock players will be skipped.");
            }
            catch (NoClassDefFoundError e) {
                this.logger.warn("Floodgate plugin was found, but its API could not be loaded. Continuing without Floodgate support.");
            }
        } else {
            this.logger.info("Floodgate not found. All players will be treated as Java players.");
        }
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(this.dataFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue(Files.createDirectories(this.dataFolder, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(...)");
            }
            Path dbPath = this.dataFolder.resolve("players.db");
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbPath.toAbsolutePath());
            this.createTable();
            this.logger.info("UserEncrypt 1.0.2 initialized successfully using SQLite storage.");
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize UserEncrypt. The plugin will be disabled.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS player_aliases (original_name TEXT PRIMARY KEY, alias TEXT NOT NULL UNIQUE);";
        Connection connection = this.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            boolean bl2 = it.execute(sql);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getAlias(String originalName) {
        String string2;
        String sql = "SELECT alias FROM player_aliases WHERE original_name = ?;";
        Connection connection = this.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        AutoCloseable autoCloseable = connection.prepareStatement(sql);
        Throwable throwable = null;
        try {
            PreparedStatement pstmt = (PreparedStatement)autoCloseable;
            boolean bl = false;
            pstmt.setString(1, originalName);
            ResultSet rs = pstmt.executeQuery();
            string2 = rs.next() ? rs.getString("alias") : null;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveAlias(String originalName, String alias) {
        String sql = "INSERT INTO player_aliases(original_name, alias) VALUES(?,?);";
        Connection connection = this.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        AutoCloseable autoCloseable = connection.prepareStatement(sql);
        Throwable throwable = null;
        try {
            PreparedStatement pstmt = (PreparedStatement)autoCloseable;
            boolean bl = false;
            pstmt.setString(1, originalName);
            pstmt.setString(2, alias);
            int n = pstmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean aliasExists(String alias) {
        boolean bl;
        String sql = "SELECT 1 FROM player_aliases WHERE alias = ?;";
        Connection connection = this.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        AutoCloseable autoCloseable = connection.prepareStatement(sql);
        Throwable throwable = null;
        try {
            PreparedStatement pstmt = (PreparedStatement)autoCloseable;
            boolean bl2 = false;
            pstmt.setString(1, alias);
            bl = pstmt.executeQuery().next();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return bl;
    }

    private final String generateUniqueUsername() {
        int randomNumber;
        int maxBaseLength;
        String string2;
        CharSequence charSequence;
        Regex regex;
        String rawTitle;
        String trimmedBase;
        String newUsername = null;
        while (this.aliasExists(newUsername = ((CharSequence)(trimmedBase = StringsKt.take(rawTitle = (regex = new Regex("[^a-zA-Z0-9_]")).replace(charSequence = (CharSequence)this.faker.getGame().title(), string2 = ""), maxBaseLength = 16 - String.valueOf(randomNumber = this.faker.getRandom().nextInt(1000, 9999)).length()))).length() == 0 ? "Player" + randomNumber : trimmedBase + randomNumber)) {
        }
        return newUsername;
    }

    @Subscribe
    public final void onGameProfileRequest(@NotNull GameProfileRequestEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter(event, "event");
        UUID playerUuid = event.getGameProfile().getId();
        FloodgateLink floodgateLink = this.floodgateLink;
        if (floodgateLink != null) {
            Intrinsics.checkNotNull(playerUuid);
            bl = floodgateLink.isFloodgatePlayer(playerUuid);
        } else {
            bl = false;
        }
        if (bl) {
            this.logger.info("Player '" + event.getUsername() + "' is a Floodgate (Bedrock) player. Skipping username encryption.");
            return;
        }
        String originalName = event.getUsername();
        Intrinsics.checkNotNull(originalName);
        String string2 = this.getAlias(originalName);
        if (string2 == null) {
            Main $this$onGameProfileRequest_u24lambda_u244 = this;
            boolean bl2 = false;
            String newAlias = $this$onGameProfileRequest_u24lambda_u244.generateUniqueUsername();
            $this$onGameProfileRequest_u24lambda_u244.saveAlias(originalName, newAlias);
            $this$onGameProfileRequest_u24lambda_u244.logger.info("Registered Java player '" + originalName + "' with new alias '" + newAlias + "'.");
            string2 = newAlias;
        }
        String alias = string2;
        this.logger.info("Processing login for '" + originalName + "' as '" + alias + "'");
        byte[] byArray = ("OfflinePlayer:" + alias).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        UUID offlineUuid = UUID.nameUUIDFromBytes(byArray);
        GameProfile newProfile = new GameProfile(offlineUuid, alias, CollectionsKt.emptyList());
        event.setGameProfile(newProfile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/hariharnautiyal/velocity/userencrypt/Main$FloodgateLink;", "", "<init>", "()V", "api", "Lorg/geysermc/floodgate/api/FloodgateApi;", "kotlin.jvm.PlatformType", "Lorg/geysermc/floodgate/api/FloodgateApi;", "isFloodgatePlayer", "", "uuid", "Ljava/util/UUID;", "userencrypt"})
    private static final class FloodgateLink {
        private final FloodgateApi api = FloodgateApi.getInstance();

        public final boolean isFloodgatePlayer(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            return this.api.isFloodgatePlayer(uuid);
        }
    }
}

