/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.BasicOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExp {
    public static final int INTERSECTION = 1;
    public static final int COMPLEMENT = 2;
    public static final int EMPTY = 4;
    public static final int ANYSTRING = 8;
    public static final int AUTOMATON = 16;
    public static final int INTERVAL = 32;
    public static final int ALL = 65535;
    public static final int NONE = 0;
    private static boolean allow_mutation = false;
    Kind kind;
    RegExp exp1;
    RegExp exp2;
    String s;
    char c;
    int min;
    int max;
    int digits;
    char from;
    char to;
    String b;
    int flags;
    int pos;

    RegExp() {
    }

    public RegExp(String string2) throws IllegalArgumentException {
        this(string2, 65535);
    }

    public RegExp(String string2, int n) throws IllegalArgumentException {
        RegExp regExp;
        this.b = string2;
        this.flags = n;
        if (string2.length() == 0) {
            regExp = RegExp.makeString("");
        } else {
            regExp = this.parseUnionExp();
            if (this.pos < this.b.length()) {
                throw new IllegalArgumentException("end-of-string expected at position " + this.pos);
            }
        }
        this.kind = regExp.kind;
        this.exp1 = regExp.exp1;
        this.exp2 = regExp.exp2;
        this.s = regExp.s;
        this.c = regExp.c;
        this.min = regExp.min;
        this.max = regExp.max;
        this.digits = regExp.digits;
        this.from = regExp.from;
        this.to = regExp.to;
        this.b = null;
    }

    public Automaton toAutomaton() {
        return this.toAutomatonAllowMutate(null, null, true);
    }

    public Automaton toAutomaton(boolean bl) {
        return this.toAutomatonAllowMutate(null, null, bl);
    }

    public Automaton toAutomaton(AutomatonProvider automatonProvider) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(null, automatonProvider, true);
    }

    public Automaton toAutomaton(AutomatonProvider automatonProvider, boolean bl) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(null, automatonProvider, bl);
    }

    public Automaton toAutomaton(Map<String, Automaton> map) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(map, null, true);
    }

    public Automaton toAutomaton(Map<String, Automaton> map, boolean bl) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(map, null, bl);
    }

    public boolean setAllowMutate(boolean bl) {
        boolean bl2 = allow_mutation;
        allow_mutation = bl;
        return bl2;
    }

    private Automaton toAutomatonAllowMutate(Map<String, Automaton> map, AutomatonProvider automatonProvider, boolean bl) throws IllegalArgumentException {
        boolean bl2 = false;
        if (allow_mutation) {
            bl2 = Automaton.setAllowMutate(true);
        }
        Automaton automaton = this.toAutomaton(map, automatonProvider, bl);
        if (allow_mutation) {
            Automaton.setAllowMutate(bl2);
        }
        return automaton;
    }

    private Automaton toAutomaton(Map<String, Automaton> map, AutomatonProvider automatonProvider, boolean bl) throws IllegalArgumentException {
        Automaton automaton = null;
        switch (this.kind) {
            case REGEXP_UNION: {
                ArrayList<Automaton> arrayList = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_UNION, arrayList, map, automatonProvider, bl);
                this.findLeaves(this.exp2, Kind.REGEXP_UNION, arrayList, map, automatonProvider, bl);
                automaton = BasicOperations.union(arrayList);
                automaton.minimize();
                break;
            }
            case REGEXP_CONCATENATION: {
                ArrayList<Automaton> arrayList = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_CONCATENATION, arrayList, map, automatonProvider, bl);
                this.findLeaves(this.exp2, Kind.REGEXP_CONCATENATION, arrayList, map, automatonProvider, bl);
                automaton = BasicOperations.concatenate(arrayList);
                automaton.minimize();
                break;
            }
            case REGEXP_INTERSECTION: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl).intersection(this.exp2.toAutomaton(map, automatonProvider, bl));
                automaton.minimize();
                break;
            }
            case REGEXP_OPTIONAL: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl).optional();
                automaton.minimize();
                break;
            }
            case REGEXP_REPEAT: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl).repeat();
                automaton.minimize();
                break;
            }
            case REGEXP_REPEAT_MIN: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl).repeat(this.min);
                automaton.minimize();
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl).repeat(this.min, this.max);
                automaton.minimize();
                break;
            }
            case REGEXP_COMPLEMENT: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl).complement();
                automaton.minimize();
                break;
            }
            case REGEXP_CHAR: {
                automaton = BasicAutomata.makeChar(this.c);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                automaton = BasicAutomata.makeCharRange(this.from, this.to);
                break;
            }
            case REGEXP_ANYCHAR: {
                automaton = BasicAutomata.makeAnyChar();
                break;
            }
            case REGEXP_EMPTY: {
                automaton = BasicAutomata.makeEmpty();
                break;
            }
            case REGEXP_STRING: {
                automaton = BasicAutomata.makeString(this.s);
                break;
            }
            case REGEXP_ANYSTRING: {
                automaton = BasicAutomata.makeAnyString();
                break;
            }
            case REGEXP_AUTOMATON: {
                Automaton automaton2 = null;
                if (map != null) {
                    automaton2 = map.get(this.s);
                }
                if (automaton2 == null && automatonProvider != null) {
                    try {
                        automaton2 = automatonProvider.getAutomaton(this.s);
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException(iOException);
                    }
                }
                if (automaton2 == null) {
                    throw new IllegalArgumentException("'" + this.s + "' not found");
                }
                automaton = automaton2.clone();
                break;
            }
            case REGEXP_INTERVAL: {
                automaton = BasicAutomata.makeInterval(this.min, this.max, this.digits);
            }
        }
        return automaton;
    }

    private void findLeaves(RegExp regExp, Kind kind, List<Automaton> list, Map<String, Automaton> map, AutomatonProvider automatonProvider, boolean bl) {
        if (regExp.kind == kind) {
            this.findLeaves(regExp.exp1, kind, list, map, automatonProvider, bl);
            this.findLeaves(regExp.exp2, kind, list, map, automatonProvider, bl);
        } else {
            list.add(regExp.toAutomaton(map, automatonProvider, bl));
        }
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    StringBuilder toStringBuilder(StringBuilder stringBuilder) {
        switch (this.kind) {
            case REGEXP_UNION: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("|");
                this.exp2.toStringBuilder(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case REGEXP_CONCATENATION: {
                this.exp1.toStringBuilder(stringBuilder);
                this.exp2.toStringBuilder(stringBuilder);
                break;
            }
            case REGEXP_INTERSECTION: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("&");
                this.exp2.toStringBuilder(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case REGEXP_OPTIONAL: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append(")?");
                break;
            }
            case REGEXP_REPEAT: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append(")*");
                break;
            }
            case REGEXP_REPEAT_MIN: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("){").append(this.min).append(",}");
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("){").append(this.min).append(",").append(this.max).append("}");
                break;
            }
            case REGEXP_COMPLEMENT: {
                stringBuilder.append("~(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case REGEXP_CHAR: {
                stringBuilder.append("\\").append(this.c);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                stringBuilder.append("[\\").append(this.from).append("-\\").append(this.to).append("]");
                break;
            }
            case REGEXP_ANYCHAR: {
                stringBuilder.append(".");
                break;
            }
            case REGEXP_EMPTY: {
                stringBuilder.append("#");
                break;
            }
            case REGEXP_STRING: {
                stringBuilder.append("\"").append(this.s).append("\"");
                break;
            }
            case REGEXP_ANYSTRING: {
                stringBuilder.append("@");
                break;
            }
            case REGEXP_AUTOMATON: {
                stringBuilder.append("<").append(this.s).append(">");
                break;
            }
            case REGEXP_INTERVAL: {
                int n;
                String string2 = Integer.toString(this.min);
                String string3 = Integer.toString(this.max);
                stringBuilder.append("<");
                if (this.digits > 0) {
                    for (n = string2.length(); n < this.digits; ++n) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string2).append("-");
                if (this.digits > 0) {
                    for (n = string3.length(); n < this.digits; ++n) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string3).append(">");
            }
        }
        return stringBuilder;
    }

    public Set<String> getIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        this.getIdentifiers(hashSet);
        return hashSet;
    }

    void getIdentifiers(Set<String> set) {
        switch (this.kind) {
            case REGEXP_UNION: 
            case REGEXP_CONCATENATION: 
            case REGEXP_INTERSECTION: {
                this.exp1.getIdentifiers(set);
                this.exp2.getIdentifiers(set);
                break;
            }
            case REGEXP_OPTIONAL: 
            case REGEXP_REPEAT: 
            case REGEXP_REPEAT_MIN: 
            case REGEXP_REPEAT_MINMAX: 
            case REGEXP_COMPLEMENT: {
                this.exp1.getIdentifiers(set);
                break;
            }
            case REGEXP_AUTOMATON: {
                set.add(this.s);
                break;
            }
        }
    }

    static RegExp makeUnion(RegExp regExp, RegExp regExp2) {
        RegExp regExp3 = new RegExp();
        regExp3.kind = Kind.REGEXP_UNION;
        regExp3.exp1 = regExp;
        regExp3.exp2 = regExp2;
        return regExp3;
    }

    static RegExp makeConcatenation(RegExp regExp, RegExp regExp2) {
        if (!(regExp.kind != Kind.REGEXP_CHAR && regExp.kind != Kind.REGEXP_STRING || regExp2.kind != Kind.REGEXP_CHAR && regExp2.kind != Kind.REGEXP_STRING)) {
            return RegExp.makeString(regExp, regExp2);
        }
        RegExp regExp3 = new RegExp();
        regExp3.kind = Kind.REGEXP_CONCATENATION;
        if (!(regExp.kind != Kind.REGEXP_CONCATENATION || regExp.exp2.kind != Kind.REGEXP_CHAR && regExp.exp2.kind != Kind.REGEXP_STRING || regExp2.kind != Kind.REGEXP_CHAR && regExp2.kind != Kind.REGEXP_STRING)) {
            regExp3.exp1 = regExp.exp1;
            regExp3.exp2 = RegExp.makeString(regExp.exp2, regExp2);
        } else if (!(regExp.kind != Kind.REGEXP_CHAR && regExp.kind != Kind.REGEXP_STRING || regExp2.kind != Kind.REGEXP_CONCATENATION || regExp2.exp1.kind != Kind.REGEXP_CHAR && regExp2.exp1.kind != Kind.REGEXP_STRING)) {
            regExp3.exp1 = RegExp.makeString(regExp, regExp2.exp1);
            regExp3.exp2 = regExp2.exp2;
        } else {
            regExp3.exp1 = regExp;
            regExp3.exp2 = regExp2;
        }
        return regExp3;
    }

    private static RegExp makeString(RegExp regExp, RegExp regExp2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (regExp.kind == Kind.REGEXP_STRING) {
            stringBuilder.append(regExp.s);
        } else {
            stringBuilder.append(regExp.c);
        }
        if (regExp2.kind == Kind.REGEXP_STRING) {
            stringBuilder.append(regExp2.s);
        } else {
            stringBuilder.append(regExp2.c);
        }
        return RegExp.makeString(stringBuilder.toString());
    }

    static RegExp makeIntersection(RegExp regExp, RegExp regExp2) {
        RegExp regExp3 = new RegExp();
        regExp3.kind = Kind.REGEXP_INTERSECTION;
        regExp3.exp1 = regExp;
        regExp3.exp2 = regExp2;
        return regExp3;
    }

    static RegExp makeOptional(RegExp regExp) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_OPTIONAL;
        regExp2.exp1 = regExp;
        return regExp2;
    }

    static RegExp makeRepeat(RegExp regExp) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_REPEAT;
        regExp2.exp1 = regExp;
        return regExp2;
    }

    static RegExp makeRepeat(RegExp regExp, int n) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_REPEAT_MIN;
        regExp2.exp1 = regExp;
        regExp2.min = n;
        return regExp2;
    }

    static RegExp makeRepeat(RegExp regExp, int n, int n2) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_REPEAT_MINMAX;
        regExp2.exp1 = regExp;
        regExp2.min = n;
        regExp2.max = n2;
        return regExp2;
    }

    static RegExp makeComplement(RegExp regExp) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_COMPLEMENT;
        regExp2.exp1 = regExp;
        return regExp2;
    }

    static RegExp makeChar(char c) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_CHAR;
        regExp.c = c;
        return regExp;
    }

    static RegExp makeCharRange(char c, char c2) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_CHAR_RANGE;
        regExp.from = c;
        regExp.to = c2;
        return regExp;
    }

    static RegExp makeAnyChar() {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_ANYCHAR;
        return regExp;
    }

    static RegExp makeEmpty() {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_EMPTY;
        return regExp;
    }

    static RegExp makeString(String string2) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_STRING;
        regExp.s = string2;
        return regExp;
    }

    static RegExp makeAnyString() {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_ANYSTRING;
        return regExp;
    }

    static RegExp makeAutomaton(String string2) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_AUTOMATON;
        regExp.s = string2;
        return regExp;
    }

    static RegExp makeInterval(int n, int n2, int n3) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_INTERVAL;
        regExp.min = n;
        regExp.max = n2;
        regExp.digits = n3;
        return regExp;
    }

    private boolean peek(String string2) {
        return this.more() && string2.indexOf(this.b.charAt(this.pos)) != -1;
    }

    private boolean match(char c) {
        if (this.pos >= this.b.length()) {
            return false;
        }
        if (this.b.charAt(this.pos) == c) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private boolean more() {
        return this.pos < this.b.length();
    }

    private char next() throws IllegalArgumentException {
        if (!this.more()) {
            throw new IllegalArgumentException("unexpected end-of-string");
        }
        return this.b.charAt(this.pos++);
    }

    private boolean check(int n) {
        return (this.flags & n) != 0;
    }

    final RegExp parseUnionExp() throws IllegalArgumentException {
        RegExp regExp = this.parseInterExp();
        if (this.match('|')) {
            regExp = RegExp.makeUnion(regExp, this.parseUnionExp());
        }
        return regExp;
    }

    final RegExp parseInterExp() throws IllegalArgumentException {
        RegExp regExp = this.parseConcatExp();
        if (this.check(1) && this.match('&')) {
            regExp = RegExp.makeIntersection(regExp, this.parseInterExp());
        }
        return regExp;
    }

    final RegExp parseConcatExp() throws IllegalArgumentException {
        RegExp regExp = this.parseRepeatExp();
        if (!(!this.more() || this.peek(")|") || this.check(1) && this.peek("&"))) {
            regExp = RegExp.makeConcatenation(regExp, this.parseConcatExp());
        }
        return regExp;
    }

    final RegExp parseRepeatExp() throws IllegalArgumentException {
        RegExp regExp = this.parseComplExp();
        while (this.peek("?*+{")) {
            if (this.match('?')) {
                regExp = RegExp.makeOptional(regExp);
                continue;
            }
            if (this.match('*')) {
                regExp = RegExp.makeRepeat(regExp);
                continue;
            }
            if (this.match('+')) {
                regExp = RegExp.makeRepeat(regExp, 1);
                continue;
            }
            if (!this.match('{')) continue;
            int n = this.pos;
            while (this.peek("0123456789")) {
                this.next();
            }
            if (n == this.pos) {
                throw new IllegalArgumentException("integer expected at position " + this.pos);
            }
            int n2 = Integer.parseInt(this.b.substring(n, this.pos));
            int n3 = -1;
            if (this.match(',')) {
                n = this.pos;
                while (this.peek("0123456789")) {
                    this.next();
                }
                if (n != this.pos) {
                    n3 = Integer.parseInt(this.b.substring(n, this.pos));
                }
            } else {
                n3 = n2;
            }
            if (!this.match('}')) {
                throw new IllegalArgumentException("expected '}' at position " + this.pos);
            }
            if (n3 == -1) {
                regExp = RegExp.makeRepeat(regExp, n2);
                continue;
            }
            regExp = RegExp.makeRepeat(regExp, n2, n3);
        }
        return regExp;
    }

    final RegExp parseComplExp() throws IllegalArgumentException {
        if (this.check(2) && this.match('~')) {
            return RegExp.makeComplement(this.parseComplExp());
        }
        return this.parseCharClassExp();
    }

    final RegExp parseCharClassExp() throws IllegalArgumentException {
        if (this.match('[')) {
            boolean bl = false;
            if (this.match('^')) {
                bl = true;
            }
            RegExp regExp = this.parseCharClasses();
            if (bl) {
                regExp = RegExp.makeIntersection(RegExp.makeAnyChar(), RegExp.makeComplement(regExp));
            }
            if (!this.match(']')) {
                throw new IllegalArgumentException("expected ']' at position " + this.pos);
            }
            return regExp;
        }
        return this.parseSimpleExp();
    }

    final RegExp parseCharClasses() throws IllegalArgumentException {
        RegExp regExp = this.parseCharClass();
        while (this.more() && !this.peek("]")) {
            regExp = RegExp.makeUnion(regExp, this.parseCharClass());
        }
        return regExp;
    }

    final RegExp parseCharClass() throws IllegalArgumentException {
        char c = this.parseCharExp();
        if (this.match('-')) {
            if (this.peek("]")) {
                return RegExp.makeUnion(RegExp.makeChar(c), RegExp.makeChar('-'));
            }
            return RegExp.makeCharRange(c, this.parseCharExp());
        }
        return RegExp.makeChar(c);
    }

    final RegExp parseSimpleExp() throws IllegalArgumentException {
        if (this.match('.')) {
            return RegExp.makeAnyChar();
        }
        if (this.check(4) && this.match('#')) {
            return RegExp.makeEmpty();
        }
        if (this.check(8) && this.match('@')) {
            return RegExp.makeAnyString();
        }
        if (this.match('\"')) {
            int n = this.pos;
            while (this.more() && !this.peek("\"")) {
                this.next();
            }
            if (!this.match('\"')) {
                throw new IllegalArgumentException("expected '\"' at position " + this.pos);
            }
            return RegExp.makeString(this.b.substring(n, this.pos - 1));
        }
        if (this.match('(')) {
            if (this.match(')')) {
                return RegExp.makeString("");
            }
            RegExp regExp = this.parseUnionExp();
            if (!this.match(')')) {
                throw new IllegalArgumentException("expected ')' at position " + this.pos);
            }
            return regExp;
        }
        if ((this.check(16) || this.check(32)) && this.match('<')) {
            int n = this.pos;
            while (this.more() && !this.peek(">")) {
                this.next();
            }
            if (!this.match('>')) {
                throw new IllegalArgumentException("expected '>' at position " + this.pos);
            }
            String string2 = this.b.substring(n, this.pos - 1);
            int n2 = string2.indexOf(45);
            if (n2 == -1) {
                if (!this.check(16)) {
                    throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1));
                }
                return RegExp.makeAutomaton(string2);
            }
            if (!this.check(32)) {
                throw new IllegalArgumentException("illegal identifier at position " + (this.pos - 1));
            }
            try {
                if (n2 == 0 || n2 == string2.length() - 1 || n2 != string2.lastIndexOf(45)) {
                    throw new NumberFormatException();
                }
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1, string2.length());
                int n3 = Integer.parseInt(string3);
                int n4 = Integer.parseInt(string4);
                int n5 = string3.length() == string4.length() ? string3.length() : 0;
                if (n3 > n4) {
                    int n6 = n3;
                    n3 = n4;
                    n4 = n6;
                }
                return RegExp.makeInterval(n3, n4, n5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1));
            }
        }
        return RegExp.makeChar(this.parseCharExp());
    }

    final char parseCharExp() throws IllegalArgumentException {
        this.match('\\');
        return this.next();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Kind {
        REGEXP_UNION,
        REGEXP_CONCATENATION,
        REGEXP_INTERSECTION,
        REGEXP_OPTIONAL,
        REGEXP_REPEAT,
        REGEXP_REPEAT_MIN,
        REGEXP_REPEAT_MINMAX,
        REGEXP_COMPLEMENT,
        REGEXP_CHAR,
        REGEXP_CHAR_RANGE,
        REGEXP_ANYCHAR,
        REGEXP_EMPTY,
        REGEXP_STRING,
        REGEXP_ANYSTRING,
        REGEXP_AUTOMATON,
        REGEXP_INTERVAL;

    }
}

