/*
 * Decompiled with CFR 0.152.
 */
package faker.com.fasterxml.jackson.databind.deser.std;

import faker.com.fasterxml.jackson.core.JsonLocation;
import faker.com.fasterxml.jackson.core.io.ContentReference;
import faker.com.fasterxml.jackson.databind.DeserializationConfig;
import faker.com.fasterxml.jackson.databind.DeserializationContext;
import faker.com.fasterxml.jackson.databind.JavaType;
import faker.com.fasterxml.jackson.databind.PropertyMetadata;
import faker.com.fasterxml.jackson.databind.PropertyName;
import faker.com.fasterxml.jackson.databind.deser.CreatorProperty;
import faker.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import faker.com.fasterxml.jackson.databind.deser.ValueInstantiator;

public class JsonLocationInstantiator
extends ValueInstantiator.Base {
    private static final long serialVersionUID = 1L;

    public JsonLocationInstantiator() {
        super(JsonLocation.class);
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return true;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config2) {
        JavaType intType = config2.constructType(Integer.TYPE);
        JavaType longType = config2.constructType(Long.TYPE);
        return new SettableBeanProperty[]{JsonLocationInstantiator.creatorProp("sourceRef", config2.constructType(Object.class), 0), JsonLocationInstantiator.creatorProp("byteOffset", longType, 1), JsonLocationInstantiator.creatorProp("charOffset", longType, 2), JsonLocationInstantiator.creatorProp("lineNr", intType, 3), JsonLocationInstantiator.creatorProp("columnNr", intType, 4)};
    }

    private static CreatorProperty creatorProp(String name2, JavaType type, int index) {
        return CreatorProperty.construct(PropertyName.construct(name2), type, null, null, null, null, index, null, PropertyMetadata.STD_REQUIRED);
    }

    @Override
    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args2) {
        ContentReference srcRef = ContentReference.rawReference(args2[0]);
        return new JsonLocation(srcRef, JsonLocationInstantiator._long(args2[1]), JsonLocationInstantiator._long(args2[2]), JsonLocationInstantiator._int(args2[3]), JsonLocationInstantiator._int(args2[4]));
    }

    private static final long _long(Object o) {
        return o == null ? 0L : ((Number)o).longValue();
    }

    private static final int _int(Object o) {
        return o == null ? 0 : ((Number)o).intValue();
    }
}

