/*
 * Decompiled with CFR 0.152.
 */
package faker.com.ibm.icu.impl.duration.impl;

import faker.com.ibm.icu.impl.duration.impl.RecordWriter;
import faker.com.ibm.icu.lang.UCharacter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class XMLRecordWriter
implements RecordWriter {
    private Writer w;
    private List<String> nameStack;
    static final String NULL_NAME = "Null";
    private static final String INDENT = "    ";

    public XMLRecordWriter(Writer w) {
        this.w = w;
        this.nameStack = new ArrayList<String>();
    }

    @Override
    public boolean open(String title) {
        this.newline();
        this.writeString("<" + title + ">");
        this.nameStack.add(title);
        return true;
    }

    @Override
    public boolean close() {
        int ix = this.nameStack.size() - 1;
        if (ix >= 0) {
            String name2 = this.nameStack.remove(ix);
            this.newline();
            this.writeString("</" + name2 + ">");
            return true;
        }
        return false;
    }

    public void flush() {
        try {
            this.w.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void bool(String name2, boolean value) {
        this.internalString(name2, String.valueOf(value));
    }

    @Override
    public void boolArray(String name2, boolean[] values2) {
        if (values2 != null) {
            String[] stringValues = new String[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                stringValues[i2] = String.valueOf(values2[i2]);
            }
            this.stringArray(name2, stringValues);
        }
    }

    private static String ctos(char value) {
        if (value == '<') {
            return "&lt;";
        }
        if (value == '&') {
            return "&amp;";
        }
        return String.valueOf(value);
    }

    @Override
    public void character(String name2, char value) {
        if (value != '\uffff') {
            this.internalString(name2, XMLRecordWriter.ctos(value));
        }
    }

    @Override
    public void characterArray(String name2, char[] values2) {
        if (values2 != null) {
            String[] stringValues = new String[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                char value = values2[i2];
                stringValues[i2] = value == '\uffff' ? NULL_NAME : XMLRecordWriter.ctos(value);
            }
            this.internalStringArray(name2, stringValues);
        }
    }

    @Override
    public void namedIndex(String name2, String[] names, int value) {
        if (value >= 0) {
            this.internalString(name2, names[value]);
        }
    }

    @Override
    public void namedIndexArray(String name2, String[] names, byte[] values2) {
        if (values2 != null) {
            String[] stringValues = new String[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                byte value = values2[i2];
                stringValues[i2] = value < 0 ? NULL_NAME : names[value];
            }
            this.internalStringArray(name2, stringValues);
        }
    }

    public static String normalize(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = null;
        boolean inWhitespace = false;
        char c = '\u0000';
        boolean special = false;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            c = str.charAt(i2);
            if (UCharacter.isWhitespace(c)) {
                if (sb == null && (inWhitespace || c != ' ')) {
                    sb = new StringBuilder(str.substring(0, i2));
                }
                if (inWhitespace) continue;
                inWhitespace = true;
                special = false;
                c = ' ';
            } else {
                inWhitespace = false;
                boolean bl = special = c == '<' || c == '&';
                if (special && sb == null) {
                    sb = new StringBuilder(str.substring(0, i2));
                }
            }
            if (sb == null) continue;
            if (special) {
                sb.append(c == '<' ? "&lt;" : "&amp;");
                continue;
            }
            sb.append(c);
        }
        if (sb != null) {
            return sb.toString();
        }
        return str;
    }

    private void internalString(String name2, String normalizedValue) {
        if (normalizedValue != null) {
            this.newline();
            this.writeString("<" + name2 + ">" + normalizedValue + "</" + name2 + ">");
        }
    }

    private void internalStringArray(String name2, String[] normalizedValues) {
        if (normalizedValues != null) {
            this.push(name2 + "List");
            for (int i2 = 0; i2 < normalizedValues.length; ++i2) {
                String value = normalizedValues[i2];
                if (value == null) {
                    value = NULL_NAME;
                }
                this.string(name2, value);
            }
            this.pop();
        }
    }

    @Override
    public void string(String name2, String value) {
        this.internalString(name2, XMLRecordWriter.normalize(value));
    }

    @Override
    public void stringArray(String name2, String[] values2) {
        if (values2 != null) {
            this.push(name2 + "List");
            for (int i2 = 0; i2 < values2.length; ++i2) {
                String value = XMLRecordWriter.normalize(values2[i2]);
                if (value == null) {
                    value = NULL_NAME;
                }
                this.internalString(name2, value);
            }
            this.pop();
        }
    }

    @Override
    public void stringTable(String name2, String[][] values2) {
        if (values2 != null) {
            this.push(name2 + "Table");
            for (int i2 = 0; i2 < values2.length; ++i2) {
                String[] rowValues = values2[i2];
                if (rowValues == null) {
                    this.internalString(name2 + "List", NULL_NAME);
                    continue;
                }
                this.stringArray(name2, rowValues);
            }
            this.pop();
        }
    }

    private void push(String name2) {
        this.newline();
        this.writeString("<" + name2 + ">");
        this.nameStack.add(name2);
    }

    private void pop() {
        int ix = this.nameStack.size() - 1;
        String name2 = this.nameStack.remove(ix);
        this.newline();
        this.writeString("</" + name2 + ">");
    }

    private void newline() {
        this.writeString("\n");
        for (int i2 = 0; i2 < this.nameStack.size(); ++i2) {
            this.writeString(INDENT);
        }
    }

    private void writeString(String str) {
        if (this.w != null) {
            try {
                this.w.write(str);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                this.w = null;
            }
        }
    }
}

