/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.fragments;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Fragments
extends JavaPlugin
implements Listener {
    private PlayerPointsAPI ppAPI;
    private int ppm;
    private int rate;
    private String currencyName;
    private final Map<UUID, ScheduledTask> rewardTasks = new HashMap<UUID, ScheduledTask>();

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        this.ppm = config.getInt("ppm");
        this.rate = config.getInt("rate");
        this.currencyName = config.getString("currencyName");
        try {
            if (Bukkit.getPluginManager().isPluginEnabled("PlayerPoints")) {
                this.ppAPI = PlayerPoints.getInstance().getAPI();
            }
            if (this.ppAPI != null) {
                this.getLogger().info("Fragments have been enabled!");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("\u274c Failed to initialize PlayerPointsAPI: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.getLogger().info("Loaded config: ppm=" + this.ppm + ", rate=" + this.rate + ", currencyName=" + this.currencyName);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        this.getLogger().info("Disabling Fragments plugin...");
        for (ScheduledTask task : this.rewardTasks.values()) {
            try {
                task.cancel();
            }
            catch (Exception exception) {}
        }
        this.rewardTasks.clear();
        this.getLogger().info("All reward timers stopped successfully!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID UUID2 = player.getUniqueId();
        if (this.rewardTasks.containsKey(UUID2)) {
            this.rewardTasks.get(UUID2).cancel();
        }
        this.getLogger().info(String.valueOf(ChatColor.GOLD) + player.getName() + " joined the server! They wil now start receiving " + this.currencyName + "s.");
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, t -> {
            if (!player.isOnline()) {
                t.cancel();
                this.rewardTasks.remove(UUID2);
                return;
            }
            this.ppAPI.give(UUID2, this.ppm);
            player.sendActionBar(this.mm("<gold>You have received </gold><bold><aqua>" + this.ppm + "</aqua></bold> <gold>" + this.currencyName + "/s</gold>"));
        }, 1L, 1200L * (long)this.rate);
        this.rewardTasks.put(UUID2, task);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        ScheduledTask task = this.rewardTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
    }

    private Component mm(String message) {
        return MiniMessage.miniMessage().deserialize((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)(message != null ? message : "")));
    }
}

