/*
 * Decompiled with CFR 0.152.
 */
package deus.bttf.Entities;

import com.mojang.nbt.tags.CompoundTag;
import deus.bttf.Items.BTTFItems;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFishingBobber;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.MobPathfinder;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class CustomBobberEntity
extends EntityFishingBobber {
    public static final int ID_BOBBER_BITFIELD = 2;
    private int xTile;
    private int yTile;
    private int zTile;
    public Player owner;
    private int ticksInAir;
    private int ticksCatchable;
    public Entity hookedEntity;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public CustomBobberEntity(World world) {
        super(world);
        this.ticksInAir = 0;
        this.ticksCatchable = 0;
        this.hookedEntity = null;
        this.setSize(0.25f, 0.25f);
        this.ignoreFrustumCheck = true;
    }

    public CustomBobberEntity(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setPos(x, y, z);
        this.ignoreFrustumCheck = true;
    }

    public CustomBobberEntity(World world, Player owner) {
        super(world, owner);
        this.ticksInAir = 0;
        this.ticksCatchable = 0;
        this.hookedEntity = null;
        this.ignoreFrustumCheck = true;
        this.owner = owner;
        this.owner.bobberEntity = this;
        this.setSize(0.25f, 0.25f);
        this.moveTo(owner.x, owner.y + 1.62 - (double)owner.heightOffset, owner.z, owner.yRot, owner.xRot);
        this.x -= (double)(MathHelper.cos((float)(this.yRot / 180.0f * (float)Math.PI)) * 0.16f);
        this.y -= 0.1;
        this.z -= (double)(MathHelper.sin((float)(this.yRot / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        float f = 0.4f;
        this.xd = -MathHelper.sin((float)(this.yRot / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.xRot / 180.0f * (float)Math.PI)) * f;
        this.zd = MathHelper.cos((float)(this.yRot / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.xRot / 180.0f * (float)Math.PI)) * f;
        this.yd = -MathHelper.sin((float)(this.xRot / 180.0f * (float)Math.PI)) * f;
        this.shoot(this.xd, this.yd, this.zd, 1.5f, 1.0f);
    }

    protected void defineSynchedData() {
        this.entityData.define(2, (Object)0, Byte.class);
    }

    public boolean isInGround() {
        return this.entityData.getByte(2) != 0;
    }

    public void setInGround(boolean flag) {
        this.entityData.set(2, (Object)((byte)(flag ? 1 : 0)));
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.bb.getSize() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public void shoot(double x, double y, double z, float speed, float randomness) {
        float f2 = MathHelper.sqrt((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.random.nextGaussian() * 0.0075 * (double)randomness;
        y += this.random.nextGaussian() * 0.0075 * (double)randomness;
        z += this.random.nextGaussian() * 0.0075 * (double)randomness;
        this.xd = x *= (double)speed;
        this.yd = y *= (double)speed;
        this.zd = z *= (double)speed;
        float hAng = MathHelper.sqrt((double)(x * x + z * z));
        this.yRotO = this.yRot = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.xRotO = this.xRot = (float)(Math.atan2(y, hAng) * 180.0 / Math.PI);
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int i) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = i;
        this.xd = this.velocityX;
        this.yd = this.velocityY;
        this.zd = this.velocityZ;
    }

    public void lerpMotion(double xd, double yd, double zd) {
        this.velocityX = this.xd = xd;
        this.velocityY = this.yd = yd;
        this.velocityZ = this.zd = zd;
    }

    public void tick() {
        double d2;
        double d1;
        double d;
        super.tick();
        if (this.lerpSteps > 0) {
            double d4;
            d = this.x + (this.lerpX - this.x) / (double)this.lerpSteps;
            d1 = this.y + (this.lerpY - this.y) / (double)this.lerpSteps;
            d2 = this.z + (this.lerpZ - this.z) / (double)this.lerpSteps;
            for (d4 = this.lerpYRot - (double)this.yRot; d4 < -180.0; d4 += 360.0) {
            }
            while (d4 >= 180.0) {
                d4 -= 360.0;
            }
            this.yRot = (float)((double)this.yRot + d4 / (double)this.lerpSteps);
            this.xRot = (float)((double)this.xRot + (this.lerpXRot - (double)this.xRot) / (double)this.lerpSteps);
            --this.lerpSteps;
        } else {
            if (!this.world.isClientSide) {
                ItemStack heldPlayerItem = this.owner.getCurrentEquippedItem();
                if (this.owner.removed || !this.owner.isAlive() || heldPlayerItem == null || heldPlayerItem.getItem() != Items.TOOL_FISHINGROD || this.distanceToSqr((Entity)this.owner) > 1024.0) {
                    this.remove();
                    this.owner.bobberEntity = null;
                    return;
                }
                if (this.hookedEntity != null) {
                    if (!this.hookedEntity.removed) {
                        double d3;
                        double dy;
                        double dx;
                        double distance;
                        this.x = this.hookedEntity.x;
                        this.y = this.hookedEntity.bb.minY + (double)this.hookedEntity.bbHeight * 0.8;
                        this.z = this.hookedEntity.z;
                        if (this.hookedEntity instanceof MobPathfinder) {
                            ((MobPathfinder)this.hookedEntity).setTarget((Entity)this.owner);
                        }
                        if ((distance = (double)MathHelper.sqrt((double)((dx = this.owner.x - this.x) * dx + (dy = this.owner.y - this.y) * dy + (d3 = this.owner.z - this.z) * d3))) > 10.0) {
                            double scale = 0.01;
                            Entity var10000 = this.hookedEntity;
                            var10000.xd += dx * scale;
                            var10000 = this.hookedEntity;
                            var10000.yd += dy * scale;
                            var10000 = this.hookedEntity;
                            var10000.zd += d3 * scale;
                        }
                        return;
                    }
                    this.hookedEntity = null;
                }
            }
            if (this.isInGround()) {
                if (this.world.getBlockId(this.xTile, this.yTile, this.zTile) == Blocks.ROPE.id()) {
                    this.x = (double)this.xTile + 0.5;
                    this.y = (double)this.yTile + 0.5;
                    this.z = (double)this.zTile + 0.5;
                    return;
                }
                this.setInGround(false);
                this.xd *= (double)(this.random.nextFloat() * 0.2f);
                this.yd *= (double)(this.random.nextFloat() * 0.2f);
                this.zd *= (double)(this.random.nextFloat() * 0.2f);
                this.ticksInAir = 0;
                this.ticksCatchable = 0;
            }
            ++this.ticksInAir;
            Vec3 currentPos = Vec3.getTempVec3((double)this.x, (double)this.y, (double)this.z);
            Vec3 nextPos = Vec3.getTempVec3((double)(this.x + this.xd), (double)(this.y + this.yd), (double)(this.z + this.zd));
            HitResult clip = this.world.checkBlockCollisionBetweenPoints(currentPos, nextPos);
            currentPos = Vec3.getTempVec3((double)this.x, (double)this.y, (double)this.z);
            nextPos = Vec3.getTempVec3((double)(this.x + this.xd), (double)(this.y + this.yd), (double)(this.z + this.zd));
            if (clip != null) {
                nextPos = Vec3.getTempVec3((double)clip.location.x, (double)clip.location.y, (double)clip.location.z);
                if (clip.hitType == HitResult.HitType.TILE && this.world.getBlockId(clip.x, clip.y, clip.z) == Blocks.ROPE.id()) {
                    this.setInGround(true);
                    this.xTile = clip.x;
                    this.yTile = clip.y;
                    this.zTile = clip.z;
                }
            }
            Entity entity = null;
            List list = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.bb.expand(this.xd, this.yd, this.zd).grow(1.0, 1.0, 1.0));
            double d3 = 0.0;
            Iterator var8 = list.iterator();
            while (true) {
                float f2;
                AABB aabb;
                HitResult newHitResult;
                double d7;
                if (!var8.hasNext()) {
                    int catchRate;
                    if (entity != null) {
                        clip = new HitResult(entity);
                    }
                    if (clip != null && clip.entity != null && clip.entity.hurt((Entity)this.owner, 0, DamageType.COMBAT)) {
                        this.hookedEntity = clip.entity;
                    }
                    this.move(this.xd, this.yd, this.zd);
                    float f = MathHelper.sqrt((double)(this.xd * this.xd + this.zd * this.zd));
                    this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
                    this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / Math.PI);
                    while (this.xRot - this.xRotO < -180.0f) {
                        this.xRotO -= 360.0f;
                    }
                    while (this.xRot - this.xRotO >= 180.0f) {
                        this.xRotO += 360.0f;
                    }
                    while (this.yRot - this.yRotO < -180.0f) {
                        this.yRotO -= 360.0f;
                    }
                    while (this.yRot - this.yRotO >= 180.0f) {
                        this.yRotO += 360.0f;
                    }
                    this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
                    this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
                    float movementScale = 0.92f;
                    if (this.onGround || this.horizontalCollision) {
                        movementScale = 0.5f;
                    }
                    int k = 5;
                    double d5 = 0.0;
                    for (catchRate = 0; catchRate < k; ++catchRate) {
                        double d8 = this.bb.minY + (this.bb.maxY - this.bb.minY) * (double)catchRate / (double)k - 0.125 + 0.125;
                        double d9 = this.bb.minY + (this.bb.maxY - this.bb.minY) * (double)(catchRate + 1) / (double)k - 0.125 + 0.125;
                        AABB axisalignedbb1 = AABB.getTemporaryBB((double)this.bb.minX, (double)d8, (double)this.bb.minZ, (double)this.bb.maxX, (double)d9, (double)this.bb.maxZ);
                        if (!this.world.isAABBInMaterial(axisalignedbb1, Material.water)) continue;
                        d5 += 1.0 / (double)k;
                    }
                    if (d5 > 0.0) {
                        if (this.ticksCatchable > 0) {
                            --this.ticksCatchable;
                        } else {
                            catchRate = 500;
                            int rainRate = 0;
                            int algaeRate = 0;
                            if (this.world.canBlockBeRainedOn(MathHelper.floor((double)this.x), MathHelper.floor((double)this.y) + 1, MathHelper.floor((double)this.z))) {
                                rainRate = 200;
                            }
                            if (this.world.getBlockId(MathHelper.floor((double)this.x), MathHelper.floor((double)this.y) + 1, MathHelper.floor((double)this.z)) == Blocks.ALGAE.id()) {
                                algaeRate = 100;
                            }
                            if (this.random.nextInt(catchRate = catchRate - rainRate - algaeRate) == 0) {
                                double xOff;
                                this.ticksCatchable = this.random.nextInt(30) + 10;
                                this.yd -= 0.2;
                                this.world.playSoundAtEntity((Entity)null, (Entity)this, "random.splash", 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                                float f3 = MathHelper.floor((double)this.bb.minY);
                                int j1 = 0;
                                while ((float)j1 < 1.0f + this.bbWidth * 20.0f) {
                                    xOff = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                                    double zOff = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                                    this.world.spawnParticle("bubble", this.x + xOff, (double)(f3 + 1.0f), this.z + zOff, this.xd, this.yd - (double)(this.random.nextFloat() * 0.2f), this.zd, 0);
                                    ++j1;
                                }
                                j1 = 0;
                                while ((float)j1 < 1.0f + this.bbWidth * 20.0f) {
                                    xOff = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                                    double zOff = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                                    this.world.spawnParticle("splash", this.x + xOff, (double)(f3 + 1.0f), this.z + zOff, this.xd, this.yd, this.zd, 0);
                                    ++j1;
                                }
                            }
                        }
                    }
                    if (this.ticksCatchable > 0) {
                        this.yd -= (double)(this.random.nextFloat() * this.random.nextFloat() * this.random.nextFloat()) * 0.2;
                    }
                    d7 = d5 * 2.0 - 1.0;
                    this.yd += 0.04 * d7;
                    if (d5 > 0.0) {
                        movementScale = (float)((double)movementScale * 0.9);
                        this.yd *= 0.8;
                    }
                    this.xd *= (double)movementScale;
                    this.yd *= (double)movementScale;
                    this.zd *= (double)movementScale;
                    this.setPos(this.x, this.y, this.z);
                    return;
                }
                Entity e = (Entity)var8.next();
                if (!e.isPickable() || e == this.owner && this.ticksInAir < 5 || (newHitResult = (aabb = e.bb.grow((double)(f2 = 0.3f), (double)f2, (double)f2)).clip(currentPos, nextPos)) == null || !((d7 = currentPos.distanceTo(newHitResult.location)) < d3) && d3 != 0.0) continue;
                entity = e;
                d3 = d7;
            }
        }
        this.setPos(d, d1, d2);
        this.setRot(this.yRot, this.xRot);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
    }

    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public int yoink() {
        double scale;
        double distance;
        double dz;
        double dy;
        double dx;
        int damage = 0;
        if (this.isInGround()) {
            dx = this.x - this.owner.x;
            dy = this.y - this.owner.y;
            dz = this.z - this.owner.z;
            distance = MathHelper.sqrt((double)(dx * dx + dy * dy + dz * dz));
            dx /= distance;
            dy /= distance;
            dz /= distance;
            scale = 0.6;
            dx = MathHelper.clamp((double)dx, (double)(-scale), (double)scale);
            dy = MathHelper.clamp((double)dy, (double)(-scale), (double)scale);
            dz = MathHelper.clamp((double)dz, (double)(-scale), (double)scale);
            scale = 2.0;
            Player var10000 = this.owner;
            var10000.xd += dx * scale;
            var10000 = this.owner;
            var10000.yd += dy * scale;
            var10000 = this.owner;
            var10000.zd += dz * scale;
            damage = 5;
        }
        if (this.hookedEntity != null) {
            dx = this.owner.x - this.x;
            dy = this.owner.y - this.y;
            dz = this.owner.z - this.z;
            distance = MathHelper.sqrt((double)(dx * dx + dy * dy + dz * dz));
            scale = 0.1;
            Entity var15 = this.hookedEntity;
            var15.xd += dx * scale;
            var15 = this.hookedEntity;
            var15.yd += dy * scale + (double)MathHelper.sqrt((double)distance) * 0.08;
            var15 = this.hookedEntity;
            var15.zd += dz * scale;
            damage = 3;
        } else if (this.ticksCatchable > 0) {
            EntityItem entityitem = new EntityItem(this.world, this.x, this.y, this.z, CustomBobberEntity.getFishByProbability().getDefaultStack());
            dx = this.owner.x - this.x;
            dy = this.owner.y - this.y;
            dz = this.owner.z - this.z;
            distance = MathHelper.sqrt((double)(dx * dx + dy * dy + dz * dz));
            scale = 0.1;
            entityitem.xd = dx * scale;
            entityitem.yd = dy * scale + (double)MathHelper.sqrt((double)distance) * 0.08;
            entityitem.zd = dz * scale;
            this.world.entityJoinedWorld((Entity)entityitem);
            this.owner.addStat(StatList.fishCaughtStat, 1);
            damage = 1;
        }
        return damage;
    }

    public static Item getFishByProbability() {
        int randomValue = (int)(Math.random() * 100.0);
        if (randomValue < 6) {
            return BTTFItems.FOOD_PUFFERFISH;
        }
        if (randomValue < 18) {
            return Items.FOOD_FISH_RAW;
        }
        if (randomValue < 24) {
            return BTTFItems.FOOD_SALMON;
        }
        if (randomValue < 48) {
            return BTTFItems.FOOD_COD;
        }
        if (randomValue < 72) {
            return BTTFItems.FOOD_TROPICAL_FISH;
        }
        if (randomValue < 82) {
            return BTTFItems.FOOD_GOLD_FISH;
        }
        return Items.AMMO_PEBBLE;
    }
}

