/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.fawereplace;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.cubexmc.fawereplace.LanguageManager;
import org.cubexmc.fawereplace.commands.FaweReplaceCommand;
import org.cubexmc.fawereplace.commands.FaweReplaceTabCompleter;
import org.cubexmc.fawereplace.tasks.CleaningTask;

public final class FAWEReplace
extends JavaPlugin {
    private CleaningTask cleaningTask;
    private World world;
    private LanguageManager languageManager;

    public void onEnable() {
        this.saveDefaultConfig();
        String language = this.getConfig().getString("language", "zh_CN");
        this.languageManager = new LanguageManager(this, language);
        this.cleaningTask = new CleaningTask(this.getLogger(), this.getDataFolder(), this.languageManager);
        this.registerCommands();
        if (!this.loadConfiguration()) {
            this.getLogger().warning(this.languageManager.getMessage("plugin.config_invalid"));
            this.getLogger().warning(this.languageManager.getMessage("plugin.command_unavailable"));
        } else if (this.getConfig().getBoolean("confirm", false)) {
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.cleaningTask.start(null));
        }
        this.getLogger().info(this.languageManager.getMessage("plugin.enabled"));
    }

    public void onDisable() {
        if (this.cleaningTask != null && this.cleaningTask.isRunning()) {
            this.cleaningTask.stop(null);
        }
        this.getLogger().info(this.languageManager.getMessage("plugin.disabled"));
    }

    private void registerCommands() {
        try {
            Command fawereplaceCmd = new Command("fawereplace"){
                private final FaweReplaceCommand executor;
                private final FaweReplaceTabCompleter tabCompleter;
                {
                    this.executor = new FaweReplaceCommand(FAWEReplace.this, FAWEReplace.this.cleaningTask);
                    this.tabCompleter = new FaweReplaceTabCompleter();
                }

                public boolean execute(CommandSender sender, String label, String[] args) {
                    return this.executor.onCommand(sender, this, label, args);
                }

                public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
                    return this.tabCompleter.onTabComplete(sender, this, alias, args);
                }
            };
            fawereplaceCmd.setDescription("FAWE-based world cleaning and block replacement");
            fawereplaceCmd.setUsage("/<command> <start|stop|status|reload|help>");
            fawereplaceCmd.setPermission("fawereplace.use");
            fawereplaceCmd.setAliases(Arrays.asList("fawerl", "frl"));
            this.getServer().getCommandMap().register("fawereplace", fawereplaceCmd);
            this.getLogger().info(this.languageManager.getMessage("plugin.command_registered"));
        }
        catch (Exception e) {
            this.getLogger().severe(this.languageManager.getMessage("plugin.command_register_failed") + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public boolean reloadConfiguration() {
        this.reloadConfig();
        String language = this.getConfig().getString("language", "zh_CN");
        this.languageManager.reload(language);
        return this.loadConfiguration();
    }

    public boolean isWorldConfigured() {
        return this.world != null;
    }

    public String getConfiguredWorldName() {
        return this.getConfig().getString("world", "world");
    }

    private boolean loadConfiguration() {
        try {
            int endY;
            int startY;
            String worldName = this.getConfig().getString("world", "world");
            this.world = this.getWorldFromFaweOrBukkit(worldName);
            if (this.world == null) {
                this.getLogger().severe(this.languageManager.getMessage("error.world_not_found", "world", worldName));
                return false;
            }
            int parallel = this.getConfig().getInt("parallel", 4);
            int regionX = this.getConfig().getInt("region.x", 512);
            int regionZ = this.getConfig().getInt("region.z", 512);
            boolean regionYFullSpan = !this.getConfig().contains("region.y");
            int regionY = regionYFullSpan ? 0 : this.getConfig().getInt("region.y", 256);
            int startX = this.getConfig().getInt("target.start.x", 0);
            int startZ = this.getConfig().getInt("target.start.z", 0);
            int endX = this.getConfig().getInt("target.end.x", 1000);
            int endZ = this.getConfig().getInt("target.end.z", 1000);
            if (!this.getConfig().contains("target.start.y") || !this.getConfig().contains("target.end.y")) {
                org.bukkit.World bw = BukkitAdapter.adapt((World)this.world);
                if (bw != null) {
                    startY = bw.getMinHeight();
                    endY = bw.getMaxHeight() - 1;
                } else {
                    startY = -64;
                    endY = 319;
                }
            } else {
                startY = this.getConfig().getInt("target.start.y");
                endY = this.getConfig().getInt("target.end.y");
            }
            if (regionYFullSpan) {
                regionY = endY - startY + 1;
            }
            boolean tiling = this.getConfig().getBoolean("tiling.enabled", true);
            boolean fastMode = this.getConfig().getBoolean("fast-mode", true);
            boolean resumeEnabled = this.getConfig().getBoolean("resume.enabled", false);
            int resumeSaveEvery = this.getConfig().getInt("resume.save-every", 25);
            String resumeFileName = this.getConfig().getString("resume.file", "progress.yml");
            File resumeFile = new File(this.getDataFolder(), resumeFileName);
            Map<BlockState, BlockType[]> blockRules = this.buildBlockRulesFromConfig();
            boolean entityCleanup = this.getConfig().getBoolean("entities.enabled", false);
            Set<EntityType> entityTypes = this.buildEntityTypesFromConfig();
            boolean skipUngeneratedChunks = this.getConfig().getBoolean("skip-ungenerated-chunks", true);
            boolean memoryProtectionEnabled = this.getConfig().getBoolean("memory-protection.enabled", true);
            double minFreeMemoryPercent = this.getConfig().getDouble("memory-protection.min-free-memory-percent", 0.2);
            long waitOnLowMemoryMs = this.getConfig().getLong("memory-protection.wait-on-low-memory-ms", 5000L);
            int maxMemoryRetries = this.getConfig().getInt("memory-protection.max-memory-retries", 10);
            long delayBetweenBatchesMs = this.getConfig().getLong("performance.delay-between-batches-ms", 100L);
            long delayBetweenChunksMs = this.getConfig().getLong("performance.delay-between-chunks-ms", 20L);
            int gcEveryChunks = this.getConfig().getInt("performance.gc-every-chunks", 50);
            this.cleaningTask.configure(this.world, startX, startY, startZ, endX, endY, endZ, parallel, tiling, fastMode, blockRules, entityCleanup, entityTypes, resumeEnabled, resumeSaveEvery, resumeFile, skipUngeneratedChunks, memoryProtectionEnabled, minFreeMemoryPercent, waitOnLowMemoryMs, maxMemoryRetries, delayBetweenBatchesMs, delayBetweenChunksMs, gcEveryChunks);
            this.cleaningTask.setRegionSize(regionX, regionY, regionZ);
            this.getLogger().info(String.format("\u5df2\u52a0\u8f7d\u914d\u7f6e: \u4e16\u754c=%s, \u533a\u57df=%dx%dx%d, \u8303\u56f4=(%d,%d,%d)->(%d,%d,%d), \u8df3\u8fc7\u672a\u751f\u6210\u533a\u5757=%s", worldName, regionX, regionY, regionZ, startX, startY, startZ, endX, endY, endZ, skipUngeneratedChunks ? "\u5f00\u542f" : "\u5173\u95ed"));
            this.getLogger().info(String.format("\u5185\u5b58\u4fdd\u62a4: %s | \u6027\u80fd\u9650\u5236: \u6279\u6b21\u5ef6\u8fdf=%dms, \u533a\u5757\u5ef6\u8fdf=%dms, GC\u9891\u7387=%d\u533a\u5757", memoryProtectionEnabled ? "\u5df2\u542f\u7528" : "\u5df2\u7981\u7528", delayBetweenBatchesMs, delayBetweenChunksMs, gcEveryChunks));
            return true;
        }
        catch (Exception e) {
            this.getLogger().severe(this.languageManager.getMessage("error.config_load_failed") + " " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private Map<BlockState, BlockType[]> buildBlockRulesFromConfig() {
        HashMap<BlockState, List> grouped = new HashMap<BlockState, List>();
        List list = this.getConfig().getList("blocks");
        if (list != null) {
            for (Object o : list) {
                String originName = null;
                String targetName = null;
                if (o instanceof ConfigurationSection) {
                    ConfigurationSection sec = (ConfigurationSection)o;
                    originName = sec.getString("origin");
                    targetName = sec.getString("target");
                } else if (o instanceof Map) {
                    Map map = (Map)o;
                    Object ov = map.get("origin");
                    Object tv = map.get("target");
                    originName = ov == null ? null : ov.toString();
                    String string = targetName = tv == null ? null : tv.toString();
                }
                if (originName == null || targetName == null) continue;
                Material om = Material.getMaterial((String)originName.toUpperCase(Locale.ROOT));
                Material tm = Material.getMaterial((String)targetName.toUpperCase(Locale.ROOT));
                if (om == null || tm == null) {
                    this.getLogger().warning("Invalid material: origin=" + originName + ", target=" + targetName);
                    continue;
                }
                BlockType ob = BlockTypes.get((String)om.name().toLowerCase(Locale.ROOT));
                BlockType tb = BlockTypes.get((String)tm.name().toLowerCase(Locale.ROOT));
                if (ob == null || tb == null) continue;
                BlockState targetState = tb.getDefaultState();
                grouped.computeIfAbsent(targetState, k -> new ArrayList()).add(ob);
            }
        }
        HashMap<BlockState, BlockType[]> compiled = new HashMap<BlockState, BlockType[]>();
        for (Map.Entry entry : grouped.entrySet()) {
            List origins = (List)entry.getValue();
            if (origins.isEmpty()) continue;
            compiled.put((BlockState)entry.getKey(), origins.toArray(new BlockType[0]));
        }
        return compiled;
    }

    private Set<EntityType> buildEntityTypesFromConfig() {
        HashSet<EntityType> types = new HashSet<EntityType>();
        List ets = this.getConfig().getStringList("entities.types");
        if (ets != null) {
            for (String s : ets) {
                if (s == null) continue;
                String key = s.trim().toUpperCase(Locale.ROOT).replace('-', '_').replace(' ', '_');
                try {
                    EntityType et = EntityType.valueOf((String)key);
                    types.add(et);
                }
                catch (IllegalArgumentException ex) {
                    this.getLogger().warning("Unknown entity type: " + s);
                }
            }
        }
        return types;
    }

    private World getWorldFromFaweOrBukkit(String worldName) {
        try {
            Class<?> faweApi = Class.forName("com.fastasyncworldedit.core.FaweAPI");
            Object weWorld = faweApi.getMethod("getWorld", String.class).invoke(null, worldName);
            if (weWorld instanceof World) {
                return (World)weWorld;
            }
        }
        catch (Throwable faweApi) {
            // empty catch block
        }
        org.bukkit.World bw = Bukkit.getWorld((String)worldName);
        return bw == null ? null : BukkitAdapter.adapt((org.bukkit.World)bw);
    }
}

