/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.fawereplace;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageManager {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final Map<String, String> messages = new HashMap<String, String>();
    private String currentLanguage;

    public LanguageManager(JavaPlugin plugin, String language) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.currentLanguage = language;
        this.loadLanguage(language);
    }

    public void loadLanguage(String language) {
        this.messages.clear();
        this.currentLanguage = language;
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + language + ".yml");
        if (!langFile.exists()) {
            this.plugin.saveResource("lang/" + language + ".yml", false);
        }
        try {
            YamlConfiguration config;
            if (langFile.exists()) {
                config = YamlConfiguration.loadConfiguration((File)langFile);
            } else {
                InputStream stream = this.plugin.getResource("lang/" + language + ".yml");
                if (stream != null) {
                    config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                } else {
                    this.logger.warning("Language file not found: " + language + ".yml, falling back to zh_CN");
                    if (!language.equals("zh_CN")) {
                        this.loadLanguage("zh_CN");
                        return;
                    }
                    return;
                }
            }
            for (String key : config.getKeys(true)) {
                if (!config.isString(key)) continue;
                this.messages.put(key, config.getString(key));
            }
            this.logger.info("Loaded language: " + language + " (" + this.messages.size() + " messages)");
        }
        catch (Exception e) {
            this.logger.severe("Failed to load language file: " + language + ".yml");
            e.printStackTrace();
        }
    }

    public String getMessage(String key) {
        return this.messages.getOrDefault(key, key);
    }

    public String getMessage(String key, Object ... replacements) {
        String message = this.getMessage(key);
        if (replacements.length % 2 != 0) {
            this.logger.warning("Invalid replacements array for key: " + key);
            return message;
        }
        for (int i = 0; i < replacements.length; i += 2) {
            String placeholder = String.valueOf(replacements[i]);
            String value = String.valueOf(replacements[i + 1]);
            message = message.replace("{" + placeholder + "}", value);
        }
        return message;
    }

    public void reload() {
        this.loadLanguage(this.currentLanguage);
    }

    public void reload(String language) {
        this.loadLanguage(language);
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }
}

