/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.fawereplace.commands;

import java.util.Locale;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.cubexmc.fawereplace.FAWEReplace;
import org.cubexmc.fawereplace.LanguageManager;
import org.cubexmc.fawereplace.tasks.CleaningTask;

public class FaweReplaceCommand
implements CommandExecutor {
    private final FAWEReplace plugin;
    private final CleaningTask cleaningTask;
    private final LanguageManager lang;

    public FaweReplaceCommand(FAWEReplace plugin, CleaningTask cleaningTask) {
        this.plugin = plugin;
        this.cleaningTask = cleaningTask;
        this.lang = plugin.getLanguageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("fawereplace.use")) {
            sender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        if (args.length == 0) {
            this.sendUsage(sender, label);
            return true;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "start": {
                this.handleStart(sender, args);
                return true;
            }
            case "stop": {
                this.handleStop(sender);
                return true;
            }
            case "status": {
                this.handleStatus(sender);
                return true;
            }
            case "reload": {
                this.handleReload(sender);
                return true;
            }
            case "help": {
                this.sendHelp(sender, label);
                return true;
            }
        }
        this.sendUsage(sender, label);
        return true;
    }

    private void handleStart(CommandSender sender, String[] args) {
        if (!this.plugin.isWorldConfigured()) {
            sender.sendMessage(this.lang.getMessage("start.world_not_configured", "world", this.plugin.getConfiguredWorldName()));
            sender.sendMessage(this.lang.getMessage("start.check_config"));
            return;
        }
        if (this.cleaningTask.isRunning()) {
            sender.sendMessage(this.lang.getMessage("start.already_running"));
            return;
        }
        boolean forceRestart = false;
        if (args.length > 1 && args[1].equalsIgnoreCase("--fresh")) {
            forceRestart = true;
        }
        this.cleaningTask.start(sender, forceRestart);
    }

    private void handleStop(CommandSender sender) {
        if (!this.cleaningTask.isRunning()) {
            sender.sendMessage(this.lang.getMessage("stop.not_running"));
            return;
        }
        this.cleaningTask.stop(sender);
        sender.sendMessage(this.lang.getMessage("stop.stopping"));
    }

    private void handleStatus(CommandSender sender) {
        if (!this.plugin.isWorldConfigured()) {
            sender.sendMessage(this.lang.getMessage("status.world_status", "world", this.plugin.getConfiguredWorldName()));
            sender.sendMessage(this.lang.getMessage("status.reload_suggestion"));
            sender.sendMessage("");
        }
        this.cleaningTask.sendStatus(sender);
    }

    private void handleReload(CommandSender sender) {
        if (this.cleaningTask.isRunning()) {
            sender.sendMessage(this.lang.getMessage("reload.cannot_while_running"));
            return;
        }
        sender.sendMessage(this.lang.getMessage("reload.reloading"));
        if (this.plugin.reloadConfiguration()) {
            sender.sendMessage(this.lang.getMessage("reload.success"));
            sender.sendMessage(this.lang.getMessage("reload.world_found", "world", this.plugin.getConfiguredWorldName()));
            sender.sendMessage(this.lang.getMessage("reload.language_changed", "language", this.lang.getCurrentLanguage()));
            sender.sendMessage(this.lang.getMessage("reload.apply_next_start"));
        } else {
            sender.sendMessage(this.lang.getMessage("reload.failed"));
            if (!this.plugin.isWorldConfigured()) {
                sender.sendMessage(this.lang.getMessage("reload.world_not_found", "world", this.plugin.getConfiguredWorldName()));
                sender.sendMessage(this.lang.getMessage("reload.check_world_name"));
            } else {
                sender.sendMessage(this.lang.getMessage("reload.check_console"));
            }
        }
    }

    private void sendUsage(CommandSender sender, String label) {
        sender.sendMessage(this.lang.getMessage("usage", "label", label));
    }

    private void sendHelp(CommandSender sender, String label) {
        sender.sendMessage(this.lang.getMessage("help.header"));
        sender.sendMessage(this.lang.getMessage("help.title"));
        sender.sendMessage("");
        sender.sendMessage(this.lang.getMessage("help.start", "label", label));
        sender.sendMessage(this.lang.getMessage("help.start_desc"));
        sender.sendMessage(this.lang.getMessage("help.start_fresh", "label", label));
        sender.sendMessage(this.lang.getMessage("help.start_fresh_desc"));
        sender.sendMessage(this.lang.getMessage("help.stop", "label", label));
        sender.sendMessage(this.lang.getMessage("help.stop_desc"));
        sender.sendMessage(this.lang.getMessage("help.status", "label", label));
        sender.sendMessage(this.lang.getMessage("help.reload", "label", label));
        sender.sendMessage(this.lang.getMessage("help.help", "label", label));
        sender.sendMessage("");
        sender.sendMessage(this.lang.getMessage("help.aliases"));
        sender.sendMessage(this.lang.getMessage("help.footer"));
    }
}

