/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.fawereplace.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class FaweReplaceTabCompleter
implements TabCompleter {
    private static final List<String> SUB_COMMANDS = Arrays.asList("start", "stop", "status", "reload", "help");
    private static final List<String> START_OPTIONS = Arrays.asList("--fresh");

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("fawereplace.use")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            return SUB_COMMANDS.stream().filter(cmd -> cmd.startsWith(input)).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("start")) {
            String input = args[1].toLowerCase();
            return START_OPTIONS.stream().filter(opt -> opt.startsWith(input)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

