/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.fawereplace.tasks;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class ChunkRepairTask {
    private final Logger logger;
    private final World world;

    public ChunkRepairTask(Logger logger, World world) {
        this.logger = logger;
        this.world = world;
    }

    public void repairChunks(int startX, int startZ, int endX, int endZ, CommandSender sender) {
        int minX = Math.min(startX, endX);
        int maxX = Math.max(startX, endX);
        int minZ = Math.min(startZ, endZ);
        int maxZ = Math.max(startZ, endZ);
        int totalChunks = (maxX - minX + 1) * (maxZ - minZ + 1);
        if (sender != null) {
            sender.sendMessage("\u00a7e\u6b63\u5728\u4fee\u590d\u533a\u5757: \u00a77" + totalChunks + " \u00a7e\u4e2a\u533a\u5757");
            sender.sendMessage("\u00a77\u533a\u5757\u8303\u56f4: \u00a7e(" + minX + ", " + minZ + ") \u00a77\u81f3 \u00a7e(" + maxX + ", " + maxZ + ")");
        }
        this.logger.info("\u5f00\u59cb\u4fee\u590d\u533a\u5757: " + totalChunks + " \u4e2a\u533a\u5757");
        CountDownLatch latch = new CountDownLatch(1);
        int[] repaired = new int[]{0};
        Bukkit.getScheduler().runTask(this.getPlugin(), () -> {
            try {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (!this.world.isChunkGenerated(x, z)) continue;
                        Chunk chunk = this.world.getChunkAt(x, z);
                        chunk.setForceLoaded(true);
                        chunk.setForceLoaded(false);
                        this.world.unloadChunk(chunk);
                        this.world.loadChunk(x, z);
                        repaired[0] = repaired[0] + 1;
                        if (repaired[0] % 100 != 0) continue;
                        this.logger.info("\u5df2\u4fee\u590d: " + repaired[0] + "/" + totalChunks);
                    }
                }
                this.logger.info("\u533a\u5757\u4fee\u590d\u5b8c\u6210\uff01\u5171\u4fee\u590d " + repaired[0] + " \u4e2a\u533a\u5757");
                if (sender != null) {
                    sender.sendMessage("\u00a7a\u533a\u5757\u4fee\u590d\u5b8c\u6210\uff01\u5171\u4fee\u590d \u00a7e" + repaired[0] + " \u00a7a\u4e2a\u533a\u5757");
                    sender.sendMessage("\u00a77\u8bf7\u91cd\u542f\u670d\u52a1\u5668\u4ee5\u786e\u4fdd\u66f4\u6539\u751f\u6548");
                }
            }
            catch (Exception e) {
                this.logger.severe("\u4fee\u590d\u533a\u5757\u65f6\u51fa\u9519: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin("FAWEReplace");
    }
}

