/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.fawereplace.tasks;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Barrel;
import org.bukkit.block.Beacon;
import org.bukkit.block.Beehive;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Campfire;
import org.bukkit.block.Chest;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.Conduit;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.block.EnchantingTable;
import org.bukkit.block.Furnace;
import org.bukkit.block.Hopper;
import org.bukkit.block.Jukebox;
import org.bukkit.block.Lectern;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.cubexmc.fawereplace.LanguageManager;

public class CleaningTask {
    private final Logger logger;
    private final File dataFolder;
    private volatile boolean running = false;
    private ExecutorService executor;
    private final AtomicInteger processed = new AtomicInteger(0);
    private final AtomicInteger total = new AtomicInteger(0);
    private final AtomicLong totalBlocksReplaced = new AtomicLong(0L);
    private final AtomicLong totalEntitiesRemoved = new AtomicLong(0L);
    private World world;
    private int taskStartX;
    private int taskStartY;
    private int taskStartZ;
    private int taskEndX;
    private int taskEndY;
    private int taskEndZ;
    private int parallel;
    private boolean tiling;
    private boolean fastMode;
    private boolean resumeEnabled;
    private int resumeSaveEvery;
    private File resumeFile;
    private final AtomicLong nextTileIndex = new AtomicLong(0L);
    private long tilesX;
    private long tilesY;
    private long tilesZ;
    private long totalTileCount;
    private int activeRegionX;
    private int activeRegionY;
    private int activeRegionZ;
    private Map<com.sk89q.worldedit.world.block.BlockState, BlockType[]> groupedBlockRules;
    private boolean entityCleanupEnabled;
    private Set<EntityType> entityTypes;
    private boolean skipUngeneratedChunks;
    private final AtomicLong skippedChunks = new AtomicLong(0L);
    private boolean memoryProtectionEnabled;
    private double minFreeMemoryPercent;
    private long waitOnLowMemoryMs;
    private int maxMemoryRetries;
    private long delayBetweenBatchesMs;
    private long delayBetweenChunksMs;
    private int gcEveryChunks;
    private final Object logLock = new Object();
    private final Object progressLock = new Object();
    private LanguageManager lang;
    private org.bukkit.World cachedBukkitWorld = null;

    public CleaningTask(Logger logger, File dataFolder, LanguageManager languageManager) {
        this.logger = logger;
        this.dataFolder = dataFolder;
        this.lang = languageManager;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void configure(World world, int startX, int startY, int startZ, int endX, int endY, int endZ, int parallel, boolean tiling, boolean fastMode, Map<com.sk89q.worldedit.world.block.BlockState, BlockType[]> blockRules, boolean entityCleanup, Set<EntityType> entities, boolean resumeEnabled, int resumeSaveEvery, File resumeFile, boolean skipUngeneratedChunks, boolean memoryProtection, double minFreeMemory, long waitOnLowMemory, int maxRetries, long delayBetweenBatches, long delayBetweenChunks, int gcEvery) {
        this.world = world;
        this.taskStartX = Math.min(startX, endX);
        this.taskStartY = Math.min(startY, endY);
        this.taskStartZ = Math.min(startZ, endZ);
        this.taskEndX = Math.max(startX, endX);
        this.taskEndY = Math.max(startY, endY);
        this.taskEndZ = Math.max(startZ, endZ);
        this.parallel = parallel;
        this.tiling = tiling;
        this.fastMode = fastMode;
        this.groupedBlockRules = blockRules;
        this.entityCleanupEnabled = entityCleanup;
        this.entityTypes = entities;
        this.resumeEnabled = resumeEnabled;
        this.resumeSaveEvery = resumeSaveEvery;
        this.resumeFile = resumeFile;
        this.skipUngeneratedChunks = skipUngeneratedChunks;
        this.skippedChunks.set(0L);
        this.memoryProtectionEnabled = memoryProtection;
        this.minFreeMemoryPercent = minFreeMemory;
        this.waitOnLowMemoryMs = waitOnLowMemory;
        this.maxMemoryRetries = maxRetries;
        this.delayBetweenBatchesMs = delayBetweenBatches;
        this.delayBetweenChunksMs = delayBetweenChunks;
        this.gcEveryChunks = gcEvery;
    }

    public void setRegionSize(int regionX, int regionY, int regionZ) {
        this.activeRegionX = regionX;
        this.activeRegionY = regionY;
        this.activeRegionZ = regionZ;
        this.tilesX = Math.max(1L, CleaningTask.ceilDiv((long)this.taskEndX - (long)this.taskStartX + 1L, regionX));
        this.tilesY = Math.max(1L, CleaningTask.ceilDiv((long)this.taskEndY - (long)this.taskStartY + 1L, regionY));
        this.tilesZ = Math.max(1L, CleaningTask.ceilDiv((long)this.taskEndZ - (long)this.taskStartZ + 1L, regionZ));
        this.totalTileCount = this.tilesX * this.tilesY * this.tilesZ;
    }

    public void start(CommandSender invoker) {
        this.start(invoker, false);
    }

    public void start(CommandSender invoker, boolean forceRestart) {
        if (this.running) {
            if (invoker != null) {
                invoker.sendMessage(this.lang.getMessage("start.already_running"));
            }
            return;
        }
        this.processed.set(0);
        this.totalBlocksReplaced.set(0L);
        this.totalEntitiesRemoved.set(0L);
        this.nextTileIndex.set(0L);
        boolean resumed = false;
        if (this.resumeEnabled && this.tiling && !forceRestart) {
            resumed = this.loadProgressIfAvailable();
            if (resumed && invoker != null) {
                invoker.sendMessage(this.lang.getMessage("start.resume_found", "progress", this.processed.get() + "/" + this.total.get()));
                invoker.sendMessage(this.lang.getMessage("start.resume_use_fresh"));
            }
        } else if (forceRestart) {
            this.clearProgressFile();
            if (invoker != null) {
                invoker.sendMessage(this.lang.getMessage("start.starting_fresh"));
            }
        }
        this.total.set((int)Math.min(this.totalTileCount, Integer.MAX_VALUE));
        this.logToFile("START", String.format("world=%s, region=%dx%dx%d, area=(%d,%d,%d)->(%d,%d,%d), parallel=%d, tiling=%s, resume=%s", this.world.getName(), this.activeRegionX, this.activeRegionY, this.activeRegionZ, this.taskStartX, this.taskStartY, this.taskStartZ, this.taskEndX, this.taskEndY, this.taskEndZ, this.parallel, this.tiling, resumed ? "resumed" : "fresh"));
        this.running = true;
        if (!this.tiling) {
            Bukkit.getScheduler().runTaskAsynchronously(this.getPlugin(), () -> {
                long changed = this.processRegion(BlockVector3.at((int)this.taskStartX, (int)this.taskStartY, (int)this.taskStartZ), BlockVector3.at((int)this.taskEndX, (int)this.taskEndY, (int)this.taskEndZ), this.fastMode);
                if (changed >= 0L) {
                    this.totalBlocksReplaced.addAndGet(changed);
                }
                this.running = false;
                this.processed.set(1);
                this.total.set(1);
                if (this.resumeEnabled) {
                    this.clearProgressFile();
                }
                this.logToFile("FINISH", "single region; blocks=" + this.totalBlocksReplaced.get() + ", entities=" + this.totalEntitiesRemoved.get());
                this.logger.info("\u66ff\u6362\u5b8c\u6210\uff0c\u5171\u5904\u7406\u4efb\u52a1\uff1a1");
            });
            this.logger.info(this.lang.getMessage("task.starting"));
            if (invoker != null) {
                invoker.sendMessage(this.lang.getMessage("start.started"));
            }
            return;
        }
        this.executor = Executors.newFixedThreadPool(Math.max(1, this.parallel));
        int logEvery = 100;
        for (int i = 0; i < this.parallel; ++i) {
            this.executor.submit(() -> this.processTiles(this.total.get(), this.activeRegionX, this.activeRegionY, this.activeRegionZ, logEvery, this.fastMode));
        }
        Bukkit.getScheduler().runTaskAsynchronously(this.getPlugin(), () -> {
            block5: {
                try {
                    this.executor.shutdown();
                    this.executor.awaitTermination(7L, TimeUnit.DAYS);
                    this.running = false;
                    if (this.processed.get() < this.total.get()) break block5;
                    this.clearProgressFile();
                }
                catch (InterruptedException e) {
                    block6: {
                        try {
                            Thread.currentThread().interrupt();
                            this.running = false;
                            if (this.processed.get() < this.total.get()) break block6;
                            this.clearProgressFile();
                        }
                        catch (Throwable throwable) {
                            this.running = false;
                            if (this.processed.get() >= this.total.get()) {
                                this.clearProgressFile();
                            }
                            this.logToFile("FINISH", String.format("regions=%d, processed=%d, blocks=%d, entities=%d", this.total.get(), this.processed.get(), this.totalBlocksReplaced.get(), this.totalEntitiesRemoved.get()));
                            this.logger.info("\u66ff\u6362\u5b8c\u6210\uff0c\u5171\u5904\u7406\u4efb\u52a1\uff1a" + this.processed.get());
                            throw throwable;
                        }
                    }
                    this.logToFile("FINISH", String.format("regions=%d, processed=%d, blocks=%d, entities=%d", this.total.get(), this.processed.get(), this.totalBlocksReplaced.get(), this.totalEntitiesRemoved.get()));
                    this.logger.info("\u66ff\u6362\u5b8c\u6210\uff0c\u5171\u5904\u7406\u4efb\u52a1\uff1a" + this.processed.get());
                }
            }
            this.logToFile("FINISH", String.format("regions=%d, processed=%d, blocks=%d, entities=%d", this.total.get(), this.processed.get(), this.totalBlocksReplaced.get(), this.totalEntitiesRemoved.get()));
            this.logger.info("\u66ff\u6362\u5b8c\u6210\uff0c\u5171\u5904\u7406\u4efb\u52a1\uff1a" + this.processed.get());
        });
        this.logger.info(resumed ? this.lang.getMessage("task.resume_loaded", "index", String.valueOf(this.processed.get()), "total", String.valueOf(this.total.get())) : this.lang.getMessage("task.starting"));
        if (invoker != null) {
            if (resumed && this.processed.get() > 0) {
                invoker.sendMessage(this.lang.getMessage("start.started"));
                invoker.sendMessage(this.lang.getMessage("status.progress", "processed", String.valueOf(this.processed.get()), "total", String.valueOf(this.total.get()), "percent", String.format("%.1f", (double)this.processed.get() * 100.0 / (double)this.total.get())));
            } else {
                invoker.sendMessage(this.lang.getMessage("start.started"));
                invoker.sendMessage(this.lang.getMessage("start.total_chunks", "total", String.valueOf(this.total.get())));
            }
        }
    }

    public void stop(CommandSender invoker) {
        if (!this.running) {
            if (invoker != null) {
                invoker.sendMessage(this.lang.getMessage("stop.not_running"));
            }
            return;
        }
        this.running = false;
        if (this.executor != null) {
            this.executor.shutdownNow();
            Bukkit.getScheduler().runTaskAsynchronously(this.getPlugin(), () -> {
                try {
                    if (this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                        this.logger.info("\u6240\u6709\u6e05\u7406\u4efb\u52a1\u5df2\u6210\u529f\u505c\u6b62\u3002");
                    } else {
                        this.logger.warning("\u90e8\u5206\u6e05\u7406\u4efb\u52a1\u672a\u80fd\u5728 30 \u79d2\u5185\u505c\u6b62\u3002");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.warning("\u7b49\u5f85\u6e05\u7406\u4efb\u52a1\u505c\u6b62\u65f6\u88ab\u4e2d\u65ad\u3002");
                }
            });
        }
        if (this.resumeEnabled) {
            this.saveProgress(this.processed.get());
            this.logger.info("\u5df2\u4fdd\u5b58\u5f53\u524d\u8fdb\u5ea6\uff0c\u4e0b\u6b21\u542f\u52a8\u65f6\u53ef\u4ee5\u7ee7\u7eed\u3002");
        }
        this.logToFile("STOP", String.format("processed=%d/%d, blocks=%d, entities=%d", this.processed.get(), this.total.get(), this.totalBlocksReplaced.get(), this.totalEntitiesRemoved.get()));
        this.logger.info("\u5df2\u8bf7\u6c42\u505c\u6b62\u6e05\u7406\u4efb\u52a1\uff0c\u6b63\u5728\u7b49\u5f85\u5f53\u524d\u533a\u5757\u5b8c\u6210...");
    }

    public void sendStatus(CommandSender sender) {
        double percent;
        if (!this.running) {
            String msg = this.lang.getMessage("status.not_running");
            if (sender != null) {
                sender.sendMessage(msg);
            } else {
                this.logger.info(msg);
            }
            return;
        }
        double d = percent = this.total.get() > 0 ? (double)this.processed.get() * 100.0 / (double)this.total.get() : 0.0;
        if (sender != null) {
            sender.sendMessage(this.lang.getMessage("status.running"));
            sender.sendMessage(this.lang.getMessage("status.progress", "processed", String.valueOf(this.processed.get()), "total", String.valueOf(this.total.get()), "percent", String.format("%.1f", percent)));
            sender.sendMessage(this.lang.getMessage("status.blocks_replaced", "blocks", String.valueOf(this.totalBlocksReplaced.get())));
            sender.sendMessage(this.lang.getMessage("status.entities_removed", "entities", String.valueOf(this.totalEntitiesRemoved.get())));
        } else {
            this.logger.info(String.format("Progress: %d/%d (%.1f%%) | Blocks: %d | Entities: %d", this.processed.get(), this.total.get(), percent, this.totalBlocksReplaced.get(), this.totalEntitiesRemoved.get()));
        }
    }

    private boolean waitForMemoryIfNeeded() {
        if (!this.memoryProtectionEnabled) {
            return true;
        }
        int retries = 0;
        while (retries < this.maxMemoryRetries || this.maxMemoryRetries < 0) {
            long freeMemory;
            long totalMemory;
            long usedMemory;
            Runtime runtime = Runtime.getRuntime();
            long maxMemory = runtime.maxMemory();
            double freePercent = (double)(maxMemory - (usedMemory = (totalMemory = runtime.totalMemory()) - (freeMemory = runtime.freeMemory()))) / (double)maxMemory;
            if (freePercent >= this.minFreeMemoryPercent) {
                if (retries > 0) {
                    this.logger.info(String.format("\u5185\u5b58\u5df2\u6062\u590d\u5230\u5b89\u5168\u6c34\u5e73 (%.1f%% \u53ef\u7528)", freePercent * 100.0));
                }
                return true;
            }
            this.logger.warning(String.format("\u5185\u5b58\u4e0d\u8db3\u8b66\u544a\uff01\u5f53\u524d\u53ef\u7528: %.1f%% (\u6700\u5c0f\u8981\u6c42: %.1f%%) - \u6682\u505c %d \u79d2 (\u91cd\u8bd5 %d/%s)", freePercent * 100.0, this.minFreeMemoryPercent * 100.0, this.waitOnLowMemoryMs / 1000L, ++retries, this.maxMemoryRetries < 0 ? "\u221e" : String.valueOf(this.maxMemoryRetries)));
            System.gc();
            try {
                Thread.sleep(this.waitOnLowMemoryMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warning("\u5185\u5b58\u7b49\u5f85\u88ab\u4e2d\u65ad");
                return false;
            }
            if (this.running) continue;
            return false;
        }
        this.logger.severe(String.format("\u5185\u5b58\u6301\u7eed\u4e0d\u8db3\uff0c\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570 (%d)\u3002\u4efb\u52a1\u5c06\u4e2d\u6b62\u4ee5\u9632\u6b62\u5d29\u6e83\u3002", this.maxMemoryRetries));
        this.logger.severe("\u5efa\u8bae: 1) \u589e\u52a0\u670d\u52a1\u5668\u5185\u5b58 2) \u51cf\u5c11 parallel \u53c2\u6570 3) \u8c03\u6574 memory-protection \u8bbe\u7f6e");
        this.running = false;
        return false;
    }

    private void processTiles(int totalTilesInt, int rX, int rY, int rZ, int logEvery, boolean fastMode) {
        while (true) {
            long changed;
            if (!this.running || Thread.currentThread().isInterrupted()) {
                this.logger.info("\u5de5\u4f5c\u7ebf\u7a0b\u68c0\u6d4b\u5230\u505c\u6b62\u4fe1\u53f7\uff0c\u6b63\u5728\u9000\u51fa...");
                return;
            }
            if (!this.waitForMemoryIfNeeded()) {
                this.logger.severe("\u5de5\u4f5c\u7ebf\u7a0b\u56e0\u5185\u5b58\u4e0d\u8db3\u800c\u4e2d\u6b62");
                return;
            }
            long index = this.nextTileIndex.getAndIncrement();
            if (index >= this.totalTileCount) {
                return;
            }
            if (this.delayBetweenBatchesMs > 0L && index > 0L) {
                try {
                    Thread.sleep(this.delayBetweenBatchesMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            BlockVector3 startLoc = this.tileIndexToStart(index, rX, rY, rZ);
            int ex = Math.min(startLoc.getBlockX() + rX - 1, this.taskEndX);
            int ey = Math.min(startLoc.getBlockY() + rY - 1, this.taskEndY);
            int ez = Math.min(startLoc.getBlockZ() + rZ - 1, this.taskEndZ);
            BlockVector3 endLoc = BlockVector3.at((int)ex, (int)ey, (int)ez);
            if (this.delayBetweenChunksMs > 0L) {
                try {
                    Thread.sleep(this.delayBetweenChunksMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if ((changed = this.processRegion(startLoc, endLoc, fastMode)) >= 0L) {
                this.totalBlocksReplaced.addAndGet(changed);
            }
            int done = this.processed.incrementAndGet();
            if (this.gcEveryChunks > 0 && done % this.gcEveryChunks == 0) {
                System.gc();
                this.logger.fine(String.format("\u5df2\u5904\u7406 %d \u533a\u5757\uff0c\u6267\u884c\u5783\u573e\u56de\u6536", done));
            }
            if (done % logEvery == 0 || done == totalTilesInt) {
                this.logger.info("\u8fdb\u5ea6: " + done + "/" + totalTilesInt);
            }
            if (!this.resumeEnabled || done % this.resumeSaveEvery != 0 && done != totalTilesInt) continue;
            this.saveProgress(done);
        }
    }

    private BlockVector3 tileIndexToStart(long index, int rX, int rY, int rZ) {
        if (this.tilesY <= 0L || this.tilesZ <= 0L) {
            return BlockVector3.at((int)this.taskStartX, (int)this.taskStartY, (int)this.taskStartZ);
        }
        long tilesPerLayer = this.tilesY * this.tilesZ;
        long xIndex = index / tilesPerLayer;
        long remainder = index % tilesPerLayer;
        long yIndex = remainder / this.tilesZ;
        long zIndex = remainder % this.tilesZ;
        int sx = this.taskStartX + (int)(xIndex * (long)rX);
        int sy = this.taskStartY + (int)(yIndex * (long)rY);
        int sz = this.taskStartZ + (int)(zIndex * (long)rZ);
        return BlockVector3.at((int)sx, (int)sy, (int)sz);
    }

    private long processRegion(BlockVector3 startLoc, BlockVector3 endLoc, boolean fastMode) {
        if (this.skipUngeneratedChunks && !this.isRegionGenerated(startLoc, endLoc)) {
            this.skippedChunks.incrementAndGet();
            return 0L;
        }
        try (EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(this.world).build();){
            long removed;
            CuboidRegion region = new CuboidRegion(startLoc, endLoc);
            EditSession extent = editSession;
            long changedTotal = 0L;
            try {
                if (this.groupedBlockRules != null && !this.groupedBlockRules.isEmpty()) {
                    for (Map.Entry<com.sk89q.worldedit.world.block.BlockState, BlockType[]> entry : this.groupedBlockRules.entrySet()) {
                        BlockTypeMask mask = new BlockTypeMask((Extent)extent, entry.getValue());
                        BlockPattern pattern = new BlockPattern((BlockStateHolder)entry.getKey());
                        editSession.replaceBlocks((Region)region, (Mask)mask, (Pattern)pattern);
                    }
                }
                try {
                    changedTotal = editSession.getBlockChangeCount();
                }
                catch (Throwable throwable) {}
            }
            catch (MaxChangedBlocksException e) {
                this.logger.warning("\u8fbe\u5230\u6700\u5927\u65b9\u5757\u4fee\u6539\u9650\u5236: " + e.getMessage());
            }
            try {
                this.fixMismatchedTileEntitiesSync(startLoc, endLoc);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "\u6e05\u7406\u6b8b\u7559\u65b9\u5757\u5b9e\u4f53\u65f6\u53d1\u751f\u5f02\u5e38", t);
            }
            if (this.entityCleanupEnabled && (removed = this.removeEntitiesSync(startLoc, endLoc)) > 0L) {
                this.totalEntitiesRemoved.addAndGet(removed);
            }
            if (changedTotal > 0L) {
                try {
                    this.refreshChunkHeightmaps(startLoc, endLoc);
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, "\u5237\u65b0\u533a\u5757\u9ad8\u5ea6\u56fe\u65f6\u53d1\u751f\u5f02\u5e38", t);
                }
            }
            long l = changedTotal;
            return l;
        }
    }

    private void fixMismatchedTileEntitiesSync(BlockVector3 startLoc, BlockVector3 endLoc) {
        org.bukkit.World bw = BukkitAdapter.adapt((World)this.world);
        if (bw == null) {
            return;
        }
        int minX = Math.min(startLoc.getBlockX(), endLoc.getBlockX());
        int minY = Math.min(startLoc.getBlockY(), endLoc.getBlockY());
        int minZ = Math.min(startLoc.getBlockZ(), endLoc.getBlockZ());
        int maxX = Math.max(startLoc.getBlockX(), endLoc.getBlockX());
        int maxY = Math.max(startLoc.getBlockY(), endLoc.getBlockY());
        int maxZ = Math.max(startLoc.getBlockZ(), endLoc.getBlockZ());
        int startChunkX = minX >> 4;
        int endChunkX = maxX >> 4;
        int startChunkZ = minZ >> 4;
        int endChunkZ = maxZ >> 4;
        CountDownLatch latch = new CountDownLatch(1);
        Bukkit.getScheduler().runTask(this.getPlugin(), () -> {
            block8: {
                long fixed = 0L;
                try {
                    for (int cx = startChunkX; cx <= endChunkX; ++cx) {
                        for (int cz = startChunkZ; cz <= endChunkZ; ++cz) {
                            BlockState[] tiles;
                            Chunk chunk = bw.getChunkAt(cx, cz);
                            if (!chunk.isLoaded()) continue;
                            try {
                                tiles = chunk.getTileEntities();
                            }
                            catch (Throwable ignored) {
                                continue;
                            }
                            for (BlockState state : tiles) {
                                Block block;
                                Material type;
                                boolean compatible;
                                int bx = state.getX();
                                int by = state.getY();
                                int bz = state.getZ();
                                if (bx < minX || bx > maxX || by < minY || by > maxY || bz < minZ || bz > maxZ || (compatible = this.isCompatibleTileState(state, type = (block = state.getBlock()).getType()))) continue;
                                BlockData original = block.getBlockData();
                                block.setType(Material.AIR, false);
                                block.setBlockData(original, false);
                                ++fixed;
                            }
                        }
                    }
                    if (fixed <= 0L) break block8;
                    this.logger.info("\u5df2\u4fee\u590d\u4e0d\u5339\u914d\u7684\u65b9\u5757\u5b9e\u4f53: " + fixed);
                }
                catch (Throwable throwable) {
                    if (fixed > 0L) {
                        this.logger.info("\u5df2\u4fee\u590d\u4e0d\u5339\u914d\u7684\u65b9\u5757\u5b9e\u4f53: " + fixed);
                        this.logToFile("FIX_TE", "fixed-mismatched-te=" + fixed + String.format(" in region (%d,%d,%d)->(%d,%d,%d)", minX, minY, minZ, maxX, maxY, maxZ));
                    }
                    latch.countDown();
                    throw throwable;
                }
                this.logToFile("FIX_TE", "fixed-mismatched-te=" + fixed + String.format(" in region (%d,%d,%d)->(%d,%d,%d)", minX, minY, minZ, maxX, maxY, maxZ));
            }
            latch.countDown();
        });
        try {
            latch.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean isCompatibleTileState(BlockState state, Material type) {
        if (type.isAir()) {
            return false;
        }
        String name = type.name();
        if (state instanceof Chest) {
            return type == Material.CHEST || type == Material.TRAPPED_CHEST;
        }
        if (state instanceof Hopper) {
            return type == Material.HOPPER;
        }
        if (state instanceof Barrel) {
            return type == Material.BARREL;
        }
        if (state instanceof Dispenser) {
            return type == Material.DISPENSER;
        }
        if (state instanceof Dropper) {
            return type == Material.DROPPER;
        }
        if (state instanceof Furnace) {
            return type == Material.FURNACE || type == Material.BLAST_FURNACE || type == Material.SMOKER;
        }
        if (state instanceof BrewingStand) {
            return type == Material.BREWING_STAND;
        }
        if (state instanceof ShulkerBox) {
            return name.endsWith("_SHULKER_BOX") || type == Material.SHULKER_BOX;
        }
        if (state instanceof Jukebox) {
            return type == Material.JUKEBOX;
        }
        if (state instanceof Lectern) {
            return type == Material.LECTERN;
        }
        if (state instanceof Beacon) {
            return type == Material.BEACON;
        }
        if (state instanceof CreatureSpawner) {
            return type == Material.SPAWNER;
        }
        if (state instanceof EnchantingTable) {
            return type == Material.ENCHANTING_TABLE;
        }
        if (state instanceof Sign) {
            return name.endsWith("_SIGN") || name.endsWith("_WALL_SIGN");
        }
        if (state instanceof Skull) {
            return name.endsWith("_HEAD") || name.endsWith("_WALL_HEAD");
        }
        if (state instanceof Banner) {
            return name.endsWith("_BANNER") || name.endsWith("_WALL_BANNER");
        }
        if (state instanceof Beehive) {
            return type == Material.BEEHIVE || type == Material.BEE_NEST;
        }
        if (state instanceof CommandBlock) {
            return type == Material.COMMAND_BLOCK || type == Material.CHAIN_COMMAND_BLOCK || type == Material.REPEATING_COMMAND_BLOCK;
        }
        if (state instanceof Conduit) {
            return type == Material.CONDUIT;
        }
        if (state instanceof Campfire) {
            return type == Material.CAMPFIRE || type == Material.SOUL_CAMPFIRE;
        }
        return true;
    }

    private long removeEntitiesSync(BlockVector3 startLoc, BlockVector3 endLoc) {
        org.bukkit.World bw = BukkitAdapter.adapt((World)this.world);
        if (bw == null) {
            return 0L;
        }
        int minX = Math.min(startLoc.getBlockX(), endLoc.getBlockX());
        int minY = Math.min(startLoc.getBlockY(), endLoc.getBlockY());
        int minZ = Math.min(startLoc.getBlockZ(), endLoc.getBlockZ());
        int maxX = Math.max(startLoc.getBlockX(), endLoc.getBlockX());
        int maxY = Math.max(startLoc.getBlockY(), endLoc.getBlockY());
        int maxZ = Math.max(startLoc.getBlockZ(), endLoc.getBlockZ());
        CountDownLatch latch = new CountDownLatch(1);
        long[] removed = new long[]{0L};
        Bukkit.getScheduler().runTask(this.getPlugin(), () -> {
            try {
                BoundingBox box = BoundingBox.of((Location)new Location(bw, (double)minX, (double)minY, (double)minZ), (Location)new Location(bw, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1)));
                for (Entity e : bw.getNearbyEntities(box)) {
                    if (!this.entityTypes.contains(e.getType())) continue;
                    e.remove();
                    removed[0] = removed[0] + 1L;
                }
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return removed[0];
    }

    private void refreshChunkHeightmaps(BlockVector3 startLoc, BlockVector3 endLoc) {
        org.bukkit.World bw = BukkitAdapter.adapt((World)this.world);
        if (bw == null) {
            return;
        }
        int startChunkX = startLoc.getBlockX() >> 4;
        int startChunkZ = startLoc.getBlockZ() >> 4;
        int endChunkX = endLoc.getBlockX() >> 4;
        int endChunkZ = endLoc.getBlockZ() >> 4;
        CountDownLatch latch = new CountDownLatch(1);
        Bukkit.getScheduler().runTask(this.getPlugin(), () -> {
            try {
                for (int cx = startChunkX; cx <= endChunkX; ++cx) {
                    for (int cz = startChunkZ; cz <= endChunkZ; ++cz) {
                        if (!bw.isChunkLoaded(cx, cz)) continue;
                        Chunk chunk = bw.getChunkAt(cx, cz);
                        chunk.setForceLoaded(true);
                        chunk.setForceLoaded(false);
                    }
                }
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean loadProgressIfAvailable() {
        if (!this.resumeEnabled || this.resumeFile == null || !this.resumeFile.isFile()) {
            return false;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)this.resumeFile);
        String storedWorld = yaml.getString("world");
        if (storedWorld == null || !storedWorld.equalsIgnoreCase(this.world.getName())) {
            this.logger.warning("\u8fdb\u5ea6\u6587\u4ef6\u4e16\u754c\u4e0d\u5339\u914d\uff0c\u5df2\u5ffd\u7565: " + this.resumeFile.getName());
            return false;
        }
        int storedProcessed = yaml.getInt("processed-tiles", 0);
        int resumeProcessed = Math.max(0, Math.min(storedProcessed, (int)this.totalTileCount));
        this.nextTileIndex.set(resumeProcessed);
        this.processed.set(resumeProcessed);
        this.totalBlocksReplaced.set(yaml.getLong("blocks-replaced", 0L));
        this.totalEntitiesRemoved.set(yaml.getLong("entities-removed", 0L));
        this.logger.info("\u5df2\u4ece\u8fdb\u5ea6\u6587\u4ef6\u6062\u590d\uff0c\u7ee7\u7eed\u4e8e\u7b2c " + resumeProcessed + " / " + this.totalTileCount + " \u4e2a\u5207\u7247\u3002");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProgress(int processedTiles) {
        if (!this.resumeEnabled || this.resumeFile == null) {
            return;
        }
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.set("world", (Object)this.world.getName());
        yaml.set("processed-tiles", (Object)processedTiles);
        yaml.set("blocks-replaced", (Object)this.totalBlocksReplaced.get());
        yaml.set("entities-removed", (Object)this.totalEntitiesRemoved.get());
        yaml.set("timestamp", (Object)System.currentTimeMillis());
        File dir = this.resumeFile.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        Object object = this.progressLock;
        synchronized (object) {
            try {
                yaml.save(this.resumeFile);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "\u5199\u5165\u8fdb\u5ea6\u6587\u4ef6\u5931\u8d25", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProgressFile() {
        if (!this.resumeEnabled || this.resumeFile == null) {
            return;
        }
        Object object = this.progressLock;
        synchronized (object) {
            if (this.resumeFile.isFile() && !this.resumeFile.delete()) {
                this.logger.warning("\u65e0\u6cd5\u5220\u9664\u8fdb\u5ea6\u6587\u4ef6: " + this.resumeFile.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToFile(String tag, String detail) {
        File dir = this.dataFolder;
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        File file = new File(dir, "clean-log.txt");
        String line = String.format("[%s] %s | %s%n", LocalDateTime.now(), tag, detail);
        Object object = this.logLock;
        synchronized (object) {
            try (FileWriter fw = new FileWriter(file, true);){
                fw.write(line);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "\u5199\u5165\u6e05\u7406\u65e5\u5fd7\u5931\u8d25", e);
            }
        }
    }

    private boolean isRegionGenerated(BlockVector3 startLoc, BlockVector3 endLoc) {
        int[][] checkPoints;
        if (this.cachedBukkitWorld == null) {
            this.cachedBukkitWorld = BukkitAdapter.adapt((World)this.world);
            if (this.cachedBukkitWorld == null) {
                this.logger.warning("\u65e0\u6cd5\u83b7\u53d6 Bukkit \u4e16\u754c\u5bf9\u8c61\uff0c\u5c06\u5904\u7406\u6240\u6709\u533a\u57df\uff08\u4e0d\u68c0\u67e5\u533a\u5757\u751f\u6210\u72b6\u6001\uff09");
                return true;
            }
        }
        int startChunkX = startLoc.getBlockX() >> 4;
        int startChunkZ = startLoc.getBlockZ() >> 4;
        int endChunkX = endLoc.getBlockX() >> 4;
        int endChunkZ = endLoc.getBlockZ() >> 4;
        for (int[] point : checkPoints = new int[][]{{startChunkX, startChunkZ}, {endChunkX, startChunkZ}, {startChunkX, endChunkZ}, {endChunkX, endChunkZ}, {(startChunkX + endChunkX) / 2, (startChunkZ + endChunkZ) / 2}}) {
            if (!this.cachedBukkitWorld.isChunkGenerated(point[0], point[1])) continue;
            return true;
        }
        return false;
    }

    private static long ceilDiv(long value, int divisor) {
        if (divisor <= 0) {
            throw new IllegalArgumentException("divisor must be > 0");
        }
        if (value <= 0L) {
            return 0L;
        }
        return (value + (long)divisor - 1L) / (long)divisor;
    }

    private Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin("FAWEReplace");
    }
}

