package net.levente;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.levente.datagen.*;
import net.levente.world.ModConfiguredFeatures;
import net.levente.world.ModPlacedFeatures;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class CharmsDataGenerator implements DataGeneratorEntrypoint {
	@Override
	public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
		FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();

		pack.addProvider(ModModelProvider::new);
		pack.addProvider(ModLangProvider::new);
		pack.addProvider(ModRecipesProvider::new);
        pack.addProvider(ModAdvancementsProvider::new);
        pack.addProvider(ModLootTableProvider::new);
        pack.addProvider(ModBlockTagProvider::new);
        pack.addProvider(ModRegistryDataGenerator::new);
        pack.addProvider(ModItemTagProvider::new);
	}

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, ModConfiguredFeatures::bootstrap);
        registryBuilder.method_46777(class_7924.field_41245, ModPlacedFeatures::bootstrap);
    }
}
