package net.levente.datagen;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.levente.Charms;
import net.levente.items.ModItems;
import net.levente.util.ModTags;
import net.minecraft.class_161;
import net.minecraft.class_189;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_8508;
import net.minecraft.class_8779;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class ModAdvancementsProvider extends FabricAdvancementProvider {
    public ModAdvancementsProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, registryLookup);
    }

    @Override
    public void generateAdvancement(class_7225.class_7874 registryLookup, Consumer<class_8779> consumer) {
        class_2073 relics = class_2073.class_2074.method_8973().method_8975(ModTags.Items.ARTIFACT_ITEMS).method_8976();


        class_8779 getRuby = class_161.class_162.method_707()
                .method_697(
                        ModItems.RUBY, // Display icon
                        class_2561.method_43470("Introduction into relics"), // Title
                        class_2561.method_43470("Look at some craftings with ruby!"), // desc.
                        class_2960.method_60656("textures/gui/advancements/backgrounds/adventure.png"), // background only if this is a root advancement
                        class_189.field_1249,
                        true, // Show the toast when completing
                        true, // Announce it to chat
                        false // Hide until achieved
                )

                .method_705("got_ruby", class_2066.class_2068.method_8959(ModItems.RUBY))

                .method_694(consumer, Charms.MOD_ID + ":get_ruby");

        class_8779 getRelic = class_161.class_162.method_707()
                .method_701(getRuby)
                .method_697(
                        ModItems.AMULET_STRING,
                        class_2561.method_43470("Ancient relics!"),
                        class_2561.method_43470("Wow, what do these do?"),
                        null,
                        class_189.field_1250,
                        true,
                        true,
                        false
                )

                .method_705("got_relic", class_2066.class_2068.method_8957(relics))

                .method_694(consumer, Charms.MOD_ID + ":get_relic");

        class_8779 getSculkCharm = class_161.class_162.method_707()
                .method_701(getRuby)
                .method_697(
                        ModItems.SCULK_CHARM,
                        class_2561.method_43470("Playing with sculk"),
                        class_2561.method_43470("You can't hear me now!"),
                        null,
                        class_189.field_1249,
                        true,
                        true,
                        false
                )

                .method_705("got_sculk_charm", class_2066.class_2068.method_8959(ModItems.SCULK_CHARM))

                .method_694(consumer, Charms.MOD_ID + ":get_sculk_charm");

        class_8779 craftEtherCrown = class_161.class_162.method_707()
                .method_701(getRuby)
                .method_697(
                        ModItems.ETHER_CROWN,
                        class_2561.method_43470("Holy crown"),
                        class_2561.method_43470("The holiest crown"),
                        null,
                        class_189.field_1250,
                        true,
                        true,
                        true
                )

                .method_705("crafted_ether_crown", class_8508.class_8509.method_51352(class_2960.method_60655(Charms.MOD_ID, "ether_crown")))

                .method_694(consumer, Charms.MOD_ID + ":craft_ether_crown");
    }
}
