package net.levente.datagen;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.levente.Charms;
import net.levente.blocks.ModBlocks;
import net.levente.items.ModItemGroups;
import net.levente.items.ModItems;
import net.levente.items.custom.EtherCrown;
import net.levente.items.custom.LapisRing;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.CompletableFuture;

public class ModLangProvider extends FabricLanguageProvider {
    private static final class_2561 BRACELET = class_2561.method_43471("trinkets.slot.hand.bracelet");

    public ModLangProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    private static void addText(@NotNull TranslationBuilder builder, @NotNull class_2561 text, @NotNull String value) {
        if (text.method_10851() instanceof class_2588 translatableTextContent) {
            builder.add(translatableTextContent.method_11022(), value);
        } else {
            Charms.LOGGER.error("Failed to add translation for text: " + text);
        }
    }

    @Override
    public void generateTranslations(class_7225.class_7874 registryLookup, TranslationBuilder translationBuilder) {
        translationBuilder.add(ModItems.RUBY, "Ruby");
        translationBuilder.add(ModItems.RUBY_AMULET, "Ruby Amulet");
        translationBuilder.add(ModItems.LAPIS_RING, "Lapis Ring");
        addText(translationBuilder, ModItemGroups.CHARMS_TITLE, "Charms Item Group");
        addText(translationBuilder, LapisRing.LAPIS_RING_TOOLTIP_1, "§7When equipped:");
        addText(translationBuilder, LapisRing.LAPIS_RING_TOOLTIP_2, "§9Grants Water Breathing I");
        translationBuilder.add(ModItems.AMULET_STRING, "Amulet String");
        translationBuilder.add(ModItems.BASIC_RING, "Ring");
        translationBuilder.add(ModItems.RAW_RUBY, "Raw Ruby");
        addText(translationBuilder, BRACELET, "Bracelet");
        translationBuilder.add(ModItems.GOLDEN_BRACELET, "§6Binding of §cSerenity");
        translationBuilder.add(ModItems.RAW_RUBY_AMULET, "Raw Ruby Amulet");
        translationBuilder.add(ModItems.ETHER_CROWN, "§6Ether Crown");
        addText(translationBuilder, EtherCrown.ETHER_CROWN_TOOLTIP_1, "§7When equipped:");
        addText(translationBuilder, EtherCrown.ETHER_CROWN_TOOLTIP_2, "§9Grants Luck III, and Night Vision, plus cancels Mining Fatigue and Poison.");
        addText(translationBuilder, class_2561.method_43471("trinkets.slot.head.crown"), "Crown");
        translationBuilder.add(ModItems.PURIFIED_GOLD_INGOT, "Purified Gold Ingot");
        addText(translationBuilder, class_2561.method_43471("trinkets.slot.head.mask"),"Mask");
        translationBuilder.add(ModBlocks.NETHER_RUBY_ORE, "Nether Ruby Ore");
        translationBuilder.add(ModItems.SCULK_CHARM, "Crown of the Warden");
        translationBuilder.add(ModItems.SATURATION_CHARM, "§6Amulet §fof §bGluttony");
    }
}
