package net.levente.mixin;


import dev.emi.trinkets.api.TrinketsApi;
import net.levente.items.ModItems;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8514;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_8514.class_8516.class)
public class SculkCharmMixin {

    @Inject(method = "listen(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/registry/entry/RegistryEntry;Lnet/minecraft/world/event/GameEvent$Emitter;Lnet/minecraft/util/math/Vec3d;)Z",
    at = @At("HEAD"), cancellable = true)
    private void onListen(class_3218 world, class_6880<class_5712> event, class_5712.class_7397 emitter, class_243 emitterPos, CallbackInfoReturnable<Boolean> cir) {
        if (emitter.comp_713() instanceof class_1657 player) {
            boolean hasCharm = TrinketsApi.getTrinketComponent(player)
                    .map(comp -> comp.isEquipped(ModItems.SCULK_CHARM))
                    .orElse(false);

            if (hasCharm) {
                cir.setReturnValue(false);
            }
        }
    }


}


