/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simpleban;

import com.flummidill.simpleban.SimpleBan;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BanManager {
    private final SimpleBan plugin;
    private final File dbFile;
    private Connection connection;
    private String announceBans = "Admins";
    private String timezone = "UTC";
    private String dateFormat = "dd/MM/yyyy HH:mm:ss";
    private boolean showTimeZone = true;

    public BanManager(SimpleBan plugin) {
        this.plugin = plugin;
        this.dbFile = new File(plugin.getDataFolder(), "bans.db");
        this.openConnection();
        this.createTables();
    }

    private void openConnection() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Could not connect to SQLite database!");
            e.printStackTrace();
        }
    }

    private void createTables() {
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS bans (uuid TEXT NOT NULL,type TEXT NOT NULL,author TEXT NOT NULL,reason TEXT NOT NULL,unban_time BIGINT NOT NULL,PRIMARY KEY(uuid))");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS offline_players (uuid TEXT NOT NULL,plr_name TEXT NOT NULL UNIQUE,PRIMARY KEY(uuid))");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to create tables in SQLite database.");
            e.printStackTrace();
        }
    }

    public void createBan(UUID uuid, String type, String author, String reason, String duration) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        try (PreparedStatement ps = this.connection.prepareStatement("INSERT INTO bans(uuid, type, author, reason, unban_time) VALUES (?, ?, ?, ?, ?) ON CONFLICT(uuid) DO NOTHING");){
            ps.setString(1, uuid.toString());
            ps.setString(2, type);
            ps.setString(3, author);
            ps.setString(4, reason);
            ps.setString(5, duration.equals("-1") ? "-1" : this.plugin.convertDuration(duration));
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void sendBanMessage(UUID uuid, String name, CommandSender sender) {
        String[] info = this.getBanInfo(uuid);
        if (info == null || info.length < 4) {
            return;
        }
        String type = info[0];
        String author = info[1];
        String reason = info[2];
        String unban_time = this.getUnbanTime(info[3]);
        if (type == null) {
            type = "ERROR";
        }
        if (author == null) {
            author = "ERROR";
        }
        if (reason == null) {
            reason = "ERROR";
        }
        if (unban_time == null) {
            unban_time = "ERROR";
        }
        sender.sendMessage("\u00a7a" + name + " \u00a7chas been \u00a7a" + (type.equals("TEMP") ? "TEMPORARILY \u00a7cbanned for \u00a7a\"" + reason + "\" \u00a7cuntil \u00a7a" + unban_time : (type.equals("PERM") ? "PERMANENTLY \u00a7cbanned for \u00a7a\"" + reason + "\"" : type + " \u00a7cbanned")));
        switch (this.announceBans) {
            case "Admins": {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)author) || !p.hasPermission("simpleban.admin") && !p.hasPermission("simpleban.tempban") && !p.hasPermission("simpleban.permban") && !p.hasPermission("simpleban.banlist") && !p.hasPermission("simpleban.baninfo") && !p.hasPermission("simpleban.unban")) continue;
                    p.sendMessage("\u00a7a" + name + " \u00a7chas been \u00a7a" + (type.equals("TEMP") ? "TEMPORARILY \u00a7cbanned by \u00a7a" + author + " \u00a7cfor \u00a7a\"" + reason + "\" \u00a7cuntil \u00a7a" + unban_time : (type.equals("PERM") ? "PERMANENTLY \u00a7cbanned by \u00a7a" + author + " \u00a7cfor \u00a7a\"" + reason + "\"" : type + " \u00a7cbanned by \u00a7a" + author)));
                }
                break;
            }
            case "Players": {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)author) || p.hasPermission("simpleban.admin") || p.hasPermission("simpleban.tempban") || p.hasPermission("simpleban.permban") || p.hasPermission("simpleban.banlist") || p.hasPermission("simpleban.baninfo") || p.hasPermission("simpleban.unban")) continue;
                    p.sendMessage("\u00a7a" + name + " \u00a7chas been \u00a7a" + (type.equals("TEMP") ? "TEMPORARILY \u00a7cbanned by \u00a7a" + author + " \u00a7cfor \u00a7a\"" + reason + "\" \u00a7cuntil \u00a7a" + unban_time : (type.equals("PERM") ? "PERMANENTLY \u00a7cbanned by \u00a7a" + author + " \u00a7cfor \u00a7a\"" + reason + "\"" : type + " \u00a7cbanned by \u00a7a" + author)));
                }
                break;
            }
            case "Everyone": {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)sender)) continue;
                    p.sendMessage("\u00a7a" + name + " \u00a7chas been \u00a7a" + (type.equals("TEMP") ? "TEMPORARILY \u00a7cbanned by \u00a7a" + author + " \u00a7cfor \u00a7a\"" + reason + "\" \u00a7cuntil \u00a7a" + unban_time : (type.equals("PERM") ? "PERMANENTLY \u00a7cbanned by \u00a7a" + author + " \u00a7cfor \u00a7a\"" + reason + "\"" : type + " \u00a7cbanned by \u00a7a" + author)));
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isBanned(UUID uuid) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT unban_time FROM bans WHERE uuid = ?");){
            boolean bl;
            block18: {
                ResultSet rs;
                block16: {
                    boolean bl2;
                    block17: {
                        ps.setString(1, uuid.toString());
                        rs = ps.executeQuery();
                        try {
                            if (rs.getLong("unban_time") > Instant.now().getEpochSecond() || rs.getLong("unban_time") == -1L) break block16;
                            this.removeBan(uuid);
                            bl2 = false;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl2;
                }
                bl = true;
                if (rs == null) break block18;
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String[] getBanInfo(UUID uuid) {
        String[] info = new String[4];
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT type, author, reason, unban_time FROM bans WHERE uuid = ?");){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    info[0] = rs.getString("type");
                    info[1] = rs.getString("author");
                    info[2] = rs.getString("reason");
                    info[3] = rs.getString("unban_time");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return info;
    }

    public void removeBan(UUID uuid) {
        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM bans WHERE uuid = ?");){
            ps.setString(1, uuid.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void removeAllBans() {
        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM bans");){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void sendUnBanMessage(String player, CommandSender sender) {
        String author = sender.getName();
        sender.sendMessage("\u00a7a" + player + " \u00a7chas been \u00a7aUNBANNED");
        switch (this.announceBans) {
            case "Admins": {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)sender) || !p.hasPermission("simpleban.admin") && !p.hasPermission("simpleban.tempban") && !p.hasPermission("simpleban.permban") && !p.hasPermission("simpleban.banlist") && !p.hasPermission("simpleban.baninfo") && !p.hasPermission("simpleban.unban")) continue;
                    p.sendMessage("\u00a7a" + player + " \u00a7chas been \u00a7aUNBANNED \u00a7cby \u00a7a" + author);
                }
                break;
            }
            case "Players": {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)sender) || p.hasPermission("simpleban.admin") || p.hasPermission("simpleban.tempban") || p.hasPermission("simpleban.permban") || p.hasPermission("simpleban.banlist") || p.hasPermission("simpleban.baninfo") || p.hasPermission("simpleban.unban")) continue;
                    p.sendMessage("\u00a7a" + player + " \u00a7chas been \u00a7aUNBANNED \u00a7cby \u00a7a" + author);
                }
                break;
            }
            case "Everyone": {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)sender)) continue;
                    p.sendMessage("\u00a7a" + player + " \u00a7chas been \u00a7aUNBANNED \u00a7cby \u00a7a" + author);
                }
                break;
            }
        }
    }

    public void removeExpiredBans() {
        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM bans WHERE unban_time <= ? AND type != 'PERM'");){
            ps.setLong(1, Instant.now().getEpochSecond());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public TextComponent getBanMessage(UUID uuid) {
        if (uuid.toString().startsWith("00000000-0000-0000-0009")) {
            return this.getBedrockBanMessage(uuid);
        }
        return this.getJavaBanMessage(uuid);
    }

    public TextComponent getJavaBanMessage(UUID uuid) {
        String[] info = this.getBanInfo(uuid);
        if (info == null || info.length < 4) {
            return new TextComponent(String.valueOf(ChatColor.RED) + "Failed to Load Ban-Data");
        }
        String type = info[0];
        String author = info[1];
        String reason = info[2];
        String expire_time = info[3];
        if (type == null) {
            type = "ERROR";
        }
        if (author == null) {
            author = "ERROR";
        }
        if (reason == null) {
            reason = "ERROR";
        }
        if (expire_time == null) {
            expire_time = "ERROR";
        }
        TextComponent ban_message = new TextComponent();
        TextComponent ban_type = new TextComponent();
        TextComponent l1p1 = new TextComponent("You are ");
        l1p1.setColor(ChatColor.RED);
        ban_type.addExtra((BaseComponent)l1p1);
        TextComponent l1p2 = new TextComponent(type.equals("TEMP") ? "TEMPORARILY" : (type.equals("PERM") ? "PERMANENTLY" : type));
        l1p2.setColor(ChatColor.AQUA);
        ban_type.addExtra((BaseComponent)l1p2);
        TextComponent l1p3 = new TextComponent(" banned from this Server!");
        l1p3.setColor(ChatColor.RED);
        ban_type.addExtra((BaseComponent)l1p3);
        ban_message.addExtra((BaseComponent)ban_type);
        TextComponent seperator = new TextComponent();
        TextComponent l2p1 = new TextComponent("\n\n------------------------------------------------------------\n\n");
        l2p1.setColor(ChatColor.GRAY);
        seperator.addExtra((BaseComponent)l2p1);
        ban_message.addExtra((BaseComponent)seperator);
        TextComponent ban_author = new TextComponent();
        TextComponent l3p1 = new TextComponent("Author: ");
        l3p1.setColor(ChatColor.GRAY);
        ban_author.addExtra((BaseComponent)l3p1);
        TextComponent l3p2 = new TextComponent(author);
        l3p2.setColor(ChatColor.RED);
        ban_author.addExtra((BaseComponent)l3p2);
        TextComponent l3p3 = new TextComponent("\n");
        l3p3.setColor(ChatColor.GRAY);
        ban_author.addExtra((BaseComponent)l3p3);
        ban_message.addExtra((BaseComponent)ban_author);
        TextComponent ban_reason = new TextComponent();
        TextComponent l4p1 = new TextComponent("Reason: ");
        l4p1.setColor(ChatColor.GRAY);
        ban_reason.addExtra((BaseComponent)l4p1);
        TextComponent l4p2 = new TextComponent(reason);
        l4p2.setColor(ChatColor.RED);
        ban_reason.addExtra((BaseComponent)l4p2);
        TextComponent l4p3 = new TextComponent("\n");
        l4p3.setColor(ChatColor.GRAY);
        ban_reason.addExtra((BaseComponent)l4p3);
        ban_message.addExtra((BaseComponent)ban_reason);
        TextComponent ban_expire = new TextComponent();
        TextComponent l5p1 = new TextComponent("Expires: ");
        l5p1.setColor(ChatColor.GRAY);
        ban_expire.addExtra((BaseComponent)l5p1);
        TextComponent l5p2 = new TextComponent(expire_time.equals("-1") ? "NEVER" : this.getUnbanTime(expire_time));
        l5p2.setColor(ChatColor.RED);
        ban_expire.addExtra((BaseComponent)l5p2);
        ban_message.addExtra((BaseComponent)ban_expire);
        return ban_message;
    }

    public TextComponent getBedrockBanMessage(UUID uuid) {
        String[] info = this.getBanInfo(uuid);
        if (info == null || info.length < 4) {
            return new TextComponent(String.valueOf(ChatColor.RED) + "Failed to Load Ban-Data");
        }
        String type = info[0];
        String author = info[1];
        String reason = info[2];
        String expire_time = info[3];
        if (type == null) {
            type = "ERROR";
        }
        if (author == null) {
            author = "ERROR";
        }
        if (reason == null) {
            reason = "ERROR";
        }
        if (expire_time == null) {
            expire_time = "ERROR";
        }
        TextComponent ban_message = new TextComponent();
        TextComponent ban_type = new TextComponent();
        TextComponent p1 = new TextComponent("You have been ");
        p1.setColor(ChatColor.RED);
        ban_type.addExtra((BaseComponent)p1);
        TextComponent p2 = new TextComponent(type.equals("TEMP") ? "TEMPORARILY" : (type.equals("PERM") ? "PERMANENTLY" : type));
        p2.setColor(ChatColor.AQUA);
        ban_type.addExtra((BaseComponent)p2);
        TextComponent p3 = new TextComponent(" banned from this Server");
        p3.setColor(ChatColor.RED);
        ban_type.addExtra((BaseComponent)p3);
        ban_message.addExtra((BaseComponent)ban_type);
        TextComponent seperator1 = new TextComponent();
        TextComponent p4 = new TextComponent(" by ");
        p4.setColor(ChatColor.GRAY);
        seperator1.addExtra((BaseComponent)p4);
        ban_message.addExtra((BaseComponent)seperator1);
        TextComponent ban_author = new TextComponent();
        TextComponent p5 = new TextComponent(author);
        p5.setColor(ChatColor.RED);
        ban_author.addExtra((BaseComponent)p5);
        ban_message.addExtra((BaseComponent)ban_author);
        TextComponent seperator2 = new TextComponent();
        TextComponent p6 = new TextComponent(" for ");
        p6.setColor(ChatColor.GRAY);
        seperator2.addExtra((BaseComponent)p6);
        ban_message.addExtra((BaseComponent)seperator2);
        TextComponent ban_reason = new TextComponent();
        TextComponent p7 = new TextComponent("\"" + reason + "\"");
        p7.setColor(ChatColor.GRAY);
        ban_reason.addExtra((BaseComponent)p7);
        ban_message.addExtra((BaseComponent)ban_reason);
        if (type.equals("TEMP")) {
            TextComponent seperator3 = new TextComponent();
            TextComponent p8 = new TextComponent(" until ");
            p8.setColor(ChatColor.GRAY);
            seperator3.addExtra((BaseComponent)p8);
            ban_message.addExtra((BaseComponent)seperator3);
            TextComponent ban_expire = new TextComponent();
            TextComponent p9 = new TextComponent(expire_time.equals("-1") ? "NEVER" : this.getUnbanTime(expire_time));
            p9.setColor(ChatColor.RED);
            ban_expire.addExtra((BaseComponent)p9);
            ban_message.addExtra((BaseComponent)ban_expire);
        }
        return ban_message;
    }

    public String getUnbanTime(String unixTime) {
        try {
            long timestamp = Long.parseLong(unixTime);
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneId.of(this.timezone));
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateFormat);
            return dateTime.format(formatter) + (String)(this.showTimeZone ? " " + (this.timezone.equals("UTC+0") || this.timezone.equals("UTC-0") ? "UTC" : this.timezone) : "");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public void setAnnounceBans(String value) {
        this.announceBans = value;
    }

    public void setTimeZone(String value) {
        this.timezone = value;
    }

    public void setDateFormat(String value) {
        this.dateFormat = value;
    }

    public void setShowTimeZone(boolean value) {
        this.showTimeZone = value;
    }

    public void saveOfflinePlayer(UUID uuid, String playerName) {
        try {
            boolean uuidExists = false;
            PreparedStatement ps1 = this.connection.prepareStatement("SELECT 1 FROM offline_players WHERE uuid = ? LIMIT 1");
            ps1.setString(1, uuid.toString());
            ResultSet rs1 = ps1.executeQuery();
            if (rs1.next()) {
                uuidExists = true;
            }
            boolean nameExists = false;
            PreparedStatement ps2 = this.connection.prepareStatement("SELECT 1 FROM offline_players WHERE plr_name = ? LIMIT 1");
            ps2.setString(1, playerName);
            ResultSet rs2 = ps2.executeQuery();
            if (rs2.next()) {
                nameExists = true;
            }
            if (uuidExists) {
                PreparedStatement ps3 = this.connection.prepareStatement("DELETE FROM offline_players WHERE uuid = ?");
                ps3.setString(1, uuid.toString());
                ps3.executeUpdate();
            }
            if (nameExists) {
                PreparedStatement ps4 = this.connection.prepareStatement("DELETE FROM offline_players WHERE plr_name = ?");
                ps4.setString(1, playerName);
                ps4.executeUpdate();
            }
            PreparedStatement ps5 = this.connection.prepareStatement("REPLACE INTO offline_players(uuid, plr_name) VALUES (?, ?)");
            ps5.setString(1, uuid.toString());
            ps5.setString(2, playerName);
            ps5.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<String> getOfflinePlayerNameList() {
        ArrayList<String> list = new ArrayList<String>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT DISTINCT plr_name FROM offline_players");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString("plr_name");
                if (name == null) continue;
                list.add(name);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getOfflinePlayerUUID(String playerName) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM offline_players WHERE plr_name = ?");){
            ps.setString(1, playerName);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            String uuid = rs.getString("uuid");
            if (uuid != null) {
                UUID uUID = UUID.fromString(uuid);
                return uUID;
            }
            UUID uUID = null;
            return uUID;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOfflinePlayerName(UUID uuid) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM offline_players WHERE uuid = ?");){
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            String string = rs.getString("plr_name");
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

